/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.LocalFrontendHistory;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.StandaloneFrontendHistory;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendHistoryMetadata;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.UnsignedLongBitmap;
import org.opendaylight.yangtools.concepts.Identifiable;

final class FrontendHistoryMetadataBuilder
implements Identifiable<LocalHistoryIdentifier> {
    private final @NonNull Map<UnsignedLong, Boolean> closedTransactions;
    private final @NonNull MutableUnsignedLongSet purgedTransactions;
    private final @NonNull LocalHistoryIdentifier identifier;
    private boolean closed;

    FrontendHistoryMetadataBuilder(LocalHistoryIdentifier identifier) {
        this.identifier = Objects.requireNonNull(identifier);
        this.purgedTransactions = MutableUnsignedLongSet.of();
        this.closedTransactions = new HashMap<UnsignedLong, Boolean>(2);
    }

    FrontendHistoryMetadataBuilder(ClientIdentifier clientId, FrontendHistoryMetadata meta) {
        this.identifier = new LocalHistoryIdentifier(clientId, meta.getHistoryId(), meta.getCookie());
        this.closedTransactions = meta.getClosedTransactions().mutableCopy();
        this.purgedTransactions = meta.getPurgedTransactions().mutableCopy();
        this.closed = meta.isClosed();
    }

    public LocalHistoryIdentifier getIdentifier() {
        return this.identifier;
    }

    public FrontendHistoryMetadata build() {
        return new FrontendHistoryMetadata(this.identifier.getHistoryId(), this.identifier.getCookie(), this.closed, UnsignedLongBitmap.copyOf(this.closedTransactions), this.purgedTransactions.immutableCopy());
    }

    void onHistoryClosed() {
        Preconditions.checkState((this.identifier.getHistoryId() != 0L ? 1 : 0) != 0);
        this.closed = true;
    }

    void onTransactionAborted(TransactionIdentifier txId) {
        this.closedTransactions.put(UnsignedLong.fromLongBits((long)txId.getTransactionId()), Boolean.FALSE);
    }

    void onTransactionCommitted(TransactionIdentifier txId) {
        this.closedTransactions.put(UnsignedLong.fromLongBits((long)txId.getTransactionId()), Boolean.TRUE);
    }

    void onTransactionPurged(TransactionIdentifier txId) {
        long txidBits = txId.getTransactionId();
        this.closedTransactions.remove(UnsignedLong.fromLongBits((long)txidBits));
        this.purgedTransactions.add(txidBits);
    }

    void onTransactionsSkipped(ImmutableUnsignedLongSet txIds) {
        this.purgedTransactions.addAll(txIds);
    }

    @NonNull AbstractFrontendHistory toLeaderState(@NonNull Shard shard) {
        if (this.identifier.getHistoryId() == 0L) {
            return StandaloneFrontendHistory.recreate(shard.persistenceId(), this.identifier.getClientId(), shard.getDataStore(), this.closedTransactions, this.purgedTransactions);
        }
        return LocalFrontendHistory.recreate(shard.persistenceId(), shard.getDataStore(), shard.getDataStore().recreateTransactionChain(this.identifier, this.closed), this.closedTransactions, this.purgedTransactions);
    }
}

