/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.Status;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

class ShardTransactionMessageRetrySupport
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ShardTransactionMessageRetrySupport.class);
    static final Class<?> TIMER_MESSAGE_CLASS = MessageInfo.class;
    private final Set<MessageInfo> messagesToRetry = new LinkedHashSet<MessageInfo>();
    private final Shard shard;

    ShardTransactionMessageRetrySupport(Shard shard) {
        this.shard = shard;
    }

    void addMessageToRetry(Object message, ActorRef replyTo, String failureMessage) {
        LOG.debug("{}: Adding message {} to retry", (Object)this.shard.persistenceId(), message);
        MessageInfo messageInfo = new MessageInfo(message, replyTo, failureMessage);
        FiniteDuration period = this.shard.getDatastoreContext().getShardRaftConfig().getElectionTimeOutInterval().$times(2L);
        messageInfo.timer = this.shard.getContext().system().scheduler().scheduleOnce(period, this.shard.getSelf(), (Object)messageInfo, (ExecutionContext)this.shard.getContext().dispatcher(), ActorRef.noSender());
        this.messagesToRetry.add(messageInfo);
    }

    void retryMessages() {
        if (this.messagesToRetry.isEmpty()) {
            return;
        }
        MessageInfo[] copy = this.messagesToRetry.toArray(new MessageInfo[this.messagesToRetry.size()]);
        this.messagesToRetry.clear();
        for (MessageInfo info : copy) {
            LOG.debug("{}: Retrying message {}", (Object)this.shard.persistenceId(), info.message);
            info.retry(this.shard);
        }
    }

    void onTimerMessage(Object message) {
        MessageInfo messageInfo = (MessageInfo)message;
        LOG.debug("{}: Timer expired for message {}", (Object)this.shard.persistenceId(), messageInfo.message);
        this.messagesToRetry.remove(messageInfo);
        messageInfo.timedOut(this.shard);
    }

    @Override
    public void close() {
        for (MessageInfo info : this.messagesToRetry) {
            info.timedOut(this.shard);
        }
        this.messagesToRetry.clear();
    }

    private static class MessageInfo {
        final Object message;
        final ActorRef replyTo;
        final String failureMessage;
        Cancellable timer;

        MessageInfo(Object message, ActorRef replyTo, String failureMessage) {
            this.message = message;
            this.replyTo = replyTo;
            this.failureMessage = Objects.requireNonNull(failureMessage);
        }

        void retry(Shard shard) {
            this.timer.cancel();
            shard.getSelf().tell(this.message, this.replyTo);
        }

        void timedOut(Shard shard) {
            this.replyTo.tell((Object)new Status.Failure((Throwable)new NoShardLeaderException(this.failureMessage, shard.persistenceId())), shard.getSelf());
        }
    }
}

