/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.dispatch.OnComplete;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.NoOpDOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.OperationCallback;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.common.Empty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;

class SingleCommitCohortProxy
extends AbstractThreePhaseCommitCohort<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleCommitCohortProxy.class);
    private final ActorUtils actorUtils;
    private final Future<Object> cohortFuture;
    private final TransactionIdentifier transactionId;
    private volatile DOMStoreThreePhaseCommitCohort delegateCohort = NoOpDOMStoreThreePhaseCommitCohort.INSTANCE;
    private final OperationCallback.Reference operationCallbackRef;

    SingleCommitCohortProxy(ActorUtils actorUtils, Future<Object> cohortFuture, TransactionIdentifier transactionId, OperationCallback.Reference operationCallbackRef) {
        this.actorUtils = actorUtils;
        this.cohortFuture = cohortFuture;
        this.transactionId = Objects.requireNonNull(transactionId);
        this.operationCallbackRef = operationCallbackRef;
    }

    public ListenableFuture<Boolean> canCommit() {
        LOG.debug("Tx {} canCommit", (Object)this.transactionId);
        final SettableFuture returnFuture = SettableFuture.create();
        this.cohortFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object cohortResponse) {
                if (failure != null) {
                    ((OperationCallback)SingleCommitCohortProxy.this.operationCallbackRef.get()).failure();
                    returnFuture.setException(failure);
                    return;
                }
                ((OperationCallback)SingleCommitCohortProxy.this.operationCallbackRef.get()).success();
                LOG.debug("Tx {} successfully completed direct commit", (Object)SingleCommitCohortProxy.this.transactionId);
                returnFuture.set((Object)Boolean.TRUE);
            }
        }, this.actorUtils.getClientDispatcher());
        return returnFuture;
    }

    public ListenableFuture<Empty> preCommit() {
        return this.delegateCohort.preCommit();
    }

    public ListenableFuture<Empty> abort() {
        return this.delegateCohort.abort();
    }

    public ListenableFuture<? extends CommitInfo> commit() {
        return this.delegateCohort.commit();
    }

    @Override
    List<Future<Object>> getCohortFutures() {
        return List.of(this.cohortFuture);
    }
}

