/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.typesafe.config.Config;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.config.AbstractModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ModuleConfig;

public class HybridModuleShardConfigProvider
extends AbstractModuleShardConfigProvider {
    private final Config moduleShardsConfig;
    private final String modulesConfigPath;

    public HybridModuleShardConfigProvider(Config moduleShardsConfig, String modulesConfigPath) {
        this.moduleShardsConfig = Objects.requireNonNull(moduleShardsConfig, "ModuleShardsConfig can't be null");
        this.modulesConfigPath = modulesConfigPath;
    }

    @Override
    public Map<String, ModuleConfig.Builder> retrieveModuleConfigs(Configuration configuration) {
        Config modulesConfig = HybridModuleShardConfigProvider.loadConfigFromPath(this.modulesConfigPath);
        Map<String, ModuleConfig.Builder> moduleConfigMap = HybridModuleShardConfigProvider.readModuleShardsConfig(this.moduleShardsConfig);
        HybridModuleShardConfigProvider.readModulesConfig(modulesConfig, moduleConfigMap, configuration);
        return moduleConfigMap;
    }
}

