/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.datastore.messages.VersionedExternalizableMessage;

public class CanCommitTransactionReply
extends VersionedExternalizableMessage {
    private static final long serialVersionUID = 4355566635423934872L;
    private static final CanCommitTransactionReply YES = new CanCommitTransactionReply(true, 13);
    private static final CanCommitTransactionReply NO = new CanCommitTransactionReply(false, 13);
    private boolean canCommit;

    public CanCommitTransactionReply() {
    }

    private CanCommitTransactionReply(boolean canCommit, short version) {
        super(version);
        this.canCommit = canCommit;
    }

    public boolean getCanCommit() {
        return this.canCommit;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.canCommit = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.canCommit);
    }

    @Override
    public String toString() {
        return "CanCommitTransactionReply [canCommit=" + this.canCommit + ", version=" + this.getVersion() + "]";
    }

    public static CanCommitTransactionReply yes(short version) {
        return version == 13 ? YES : new CanCommitTransactionReply(true, version);
    }

    public static CanCommitTransactionReply no(short version) {
        return version == 13 ? NO : new CanCommitTransactionReply(false, version);
    }

    public static CanCommitTransactionReply fromSerializable(Object serializable) {
        Preconditions.checkArgument((boolean)(serializable instanceof CanCommitTransactionReply));
        return (CanCommitTransactionReply)serializable;
    }

    public static boolean isSerializedType(Object message) {
        return message instanceof CanCommitTransactionReply;
    }
}

