/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.VersionedExternalizableMessage;

public class CreateTransactionReply
extends VersionedExternalizableMessage {
    private static final long serialVersionUID = 1L;
    private String transactionPath;
    private TransactionIdentifier transactionId;

    public CreateTransactionReply() {
    }

    public CreateTransactionReply(String transactionPath, TransactionIdentifier transactionId, short version) {
        super(version);
        this.transactionPath = Objects.requireNonNull(transactionPath);
        this.transactionId = Objects.requireNonNull(transactionId);
    }

    public String getTransactionPath() {
        return this.transactionPath;
    }

    public TransactionIdentifier getTransactionId() {
        return this.transactionId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.transactionId = TransactionIdentifier.readFrom((DataInput)in);
        this.transactionPath = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.transactionId.writeTo((DataOutput)out);
        out.writeUTF(this.transactionPath);
    }

    @Override
    public String toString() {
        return "CreateTransactionReply [transactionPath=" + this.transactionPath + ", transactionId=" + this.transactionId + ", version=" + this.getVersion() + "]";
    }

    public static CreateTransactionReply fromSerializable(Object serializable) {
        Preconditions.checkArgument((boolean)(serializable instanceof CreateTransactionReply));
        return (CreateTransactionReply)serializable;
    }

    public static boolean isSerializedType(Object message) {
        return message instanceof CreateTransactionReply;
    }
}

