/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.datastore.messages.VersionedExternalizableMessage;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;

public class ReadDataReply
extends VersionedExternalizableMessage {
    private static final long serialVersionUID = 1L;
    private NormalizedNode normalizedNode;

    public ReadDataReply() {
    }

    public ReadDataReply(NormalizedNode normalizedNode, short version) {
        super(version);
        this.normalizedNode = normalizedNode;
    }

    public NormalizedNode getNormalizedNode() {
        return this.normalizedNode;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.normalizedNode = SerializationUtils.readNormalizedNode((DataInput)in).orElse(null);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerializationUtils.writeNormalizedNode((DataOutput)out, (NormalizedNodeStreamVersion)this.getStreamVersion(), (NormalizedNode)this.normalizedNode);
    }

    public static ReadDataReply fromSerializable(Object serializable) {
        return (ReadDataReply)serializable;
    }

    public static boolean isSerializedType(Object message) {
        return message instanceof ReadDataReply;
    }
}

