/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.persisted.DS;
import org.opendaylight.controller.cluster.datastore.persisted.DSS;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;

public final class DatastoreSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull String type;
    private final ShardManagerSnapshot shardManagerSnapshot;
    private final @NonNull ImmutableList<ShardSnapshot> shardSnapshots;

    public DatastoreSnapshot(@NonNull String type, @Nullable ShardManagerSnapshot shardManagerSnapshot, @NonNull List<ShardSnapshot> shardSnapshots) {
        this.type = Objects.requireNonNull(type);
        this.shardManagerSnapshot = shardManagerSnapshot;
        this.shardSnapshots = ImmutableList.copyOf(shardSnapshots);
    }

    public @NonNull String getType() {
        return this.type;
    }

    public @Nullable ShardManagerSnapshot getShardManagerSnapshot() {
        return this.shardManagerSnapshot;
    }

    public @NonNull List<ShardSnapshot> getShardSnapshots() {
        return this.shardSnapshots;
    }

    private Object writeReplace() {
        return new DS(this);
    }

    public static final class ShardSnapshot
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final @NonNull String name;
        private final @NonNull Snapshot snapshot;

        public ShardSnapshot(@NonNull String name, @NonNull Snapshot snapshot) {
            this.name = Objects.requireNonNull(name);
            this.snapshot = Objects.requireNonNull(snapshot);
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull Snapshot getSnapshot() {
            return this.snapshot;
        }

        private Object writeReplace() {
            return new DSS(this);
        }
    }
}

