/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataOutput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.opendaylight.controller.cluster.datastore.persisted.PH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PurgeLocalHistoryPayload
extends AbstractIdentifiablePayload<LocalHistoryIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeLocalHistoryPayload.class);
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = PurgeLocalHistoryPayload.externalizableProxySize(PH::new);

    PurgeLocalHistoryPayload(LocalHistoryIdentifier historyId, byte[] serialized) {
        super(historyId, serialized);
    }

    public static PurgeLocalHistoryPayload create(LocalHistoryIdentifier historyId, int initialSerializedBufferCapacity) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        try {
            historyId.writeTo((DataOutput)out);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {}", (Object)historyId, (Object)e);
            throw new IllegalStateException("Failed to serialize " + historyId, e);
        }
        return new PurgeLocalHistoryPayload(historyId, out.toByteArray());
    }

    @Override
    protected PH externalizableProxy(byte[] serialized) {
        return new PH(serialized);
    }

    @Override
    protected int externalizableProxySize() {
        return PROXY_SIZE;
    }
}

