/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;

final class SM
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ShardManagerSnapshot snapshot;

    public SM() {
    }

    SM(ShardManagerSnapshot snapshot) {
        this.snapshot = Objects.requireNonNull(snapshot);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ArrayList<String> shardList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            shardList.add((String)in.readObject());
        }
        this.snapshot = new ShardManagerSnapshot(shardList);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        List<String> shardList = this.snapshot.getShardList();
        out.writeInt(shardList.size());
        for (String shardName : shardList) {
            out.writeObject(shardName);
        }
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.snapshot);
    }
}

