/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.serialization.Serialization;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.PeerAddressResolved;
import org.opendaylight.controller.cluster.datastore.shardmanager.AtomicShardContextProvider;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManager;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardPeerAddressResolver;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.yangtools.yang.data.tree.api.ReadOnlyDataTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public final class ShardInformation {
    private static final Logger LOG = LoggerFactory.getLogger(ShardInformation.class);
    private final Set<ShardManager.OnShardInitialized> onShardInitializedSet = new HashSet<ShardManager.OnShardInitialized>();
    private final Map<String, String> initialPeerAddresses;
    private final ShardPeerAddressResolver addressResolver;
    private final ShardIdentifier shardId;
    private final String shardName;
    private final AtomicShardContextProvider schemaContextProvider = new AtomicShardContextProvider();
    private ActorRef actor;
    private Optional<ReadOnlyDataTree> localShardDataTree;
    private boolean leaderAvailable = false;
    private boolean actorInitialized = false;
    private boolean followerSyncStatus = false;
    private String role;
    private String leaderId;
    private short leaderVersion;
    private DatastoreContext datastoreContext;
    private Shard.AbstractBuilder<?, ?> builder;
    private boolean activeMember = true;

    ShardInformation(String shardName, ShardIdentifier shardId, Map<String, String> initialPeerAddresses, DatastoreContext datastoreContext, Shard.AbstractBuilder<?, ?> builder, ShardPeerAddressResolver addressResolver) {
        this.shardName = shardName;
        this.shardId = shardId;
        this.initialPeerAddresses = initialPeerAddresses;
        this.datastoreContext = datastoreContext;
        this.builder = builder;
        this.addressResolver = addressResolver;
    }

    Props newProps() {
        Props props = ((Shard.AbstractBuilder)((Shard.AbstractBuilder)((Shard.AbstractBuilder)((Shard.AbstractBuilder)Objects.requireNonNull(this.builder).id(this.shardId)).peerAddresses(this.initialPeerAddresses)).datastoreContext(this.datastoreContext)).schemaContextProvider(this.schemaContextProvider)).props();
        this.builder = null;
        return props;
    }

    String getShardName() {
        return this.shardName;
    }

    @VisibleForTesting
    public @Nullable ActorRef getActor() {
        return this.actor;
    }

    void setActor(ActorRef actor) {
        this.actor = actor;
    }

    ShardIdentifier getShardId() {
        return this.shardId;
    }

    void setLocalDataTree(Optional<ReadOnlyDataTree> dataTree) {
        this.localShardDataTree = dataTree;
    }

    Optional<ReadOnlyDataTree> getLocalShardDataTree() {
        return this.localShardDataTree;
    }

    DatastoreContext getDatastoreContext() {
        return this.datastoreContext;
    }

    void setDatastoreContext(DatastoreContext newDatastoreContext, ActorRef sender) {
        this.datastoreContext = newDatastoreContext;
        if (this.actor != null) {
            LOG.debug("Sending new DatastoreContext to {}", (Object)this.shardId);
            this.actor.tell((Object)this.datastoreContext, sender);
        }
    }

    void updatePeerAddress(String peerId, String peerAddress, ActorRef sender) {
        LOG.info("updatePeerAddress for peer {} with address {}", (Object)peerId, (Object)peerAddress);
        if (this.actor != null) {
            LOG.debug("Sending PeerAddressResolved for peer {} with address {} to {}", new Object[]{peerId, peerAddress, this.actor.path()});
            this.actor.tell((Object)new PeerAddressResolved(peerId, peerAddress), sender);
        }
        this.notifyOnShardInitializedCallbacks();
    }

    boolean isShardReady() {
        return !RaftState.Candidate.name().equals(this.role) && !Strings.isNullOrEmpty((String)this.role);
    }

    boolean isShardReadyWithLeaderId() {
        return this.leaderAvailable && this.isShardReady() && !RaftState.IsolatedLeader.name().equals(this.role) && !RaftState.PreLeader.name().equals(this.role) && (this.isLeader() || this.addressResolver.resolve(this.leaderId) != null);
    }

    boolean isShardInitialized() {
        return this.getActor() != null && this.actorInitialized;
    }

    boolean isLeader() {
        return Objects.equals(this.leaderId, this.shardId.toString());
    }

    String getSerializedLeaderActor() {
        return this.isLeader() ? Serialization.serializedActorPath((ActorRef)this.getActor()) : this.addressResolver.resolve(this.leaderId);
    }

    void setActorInitialized() {
        LOG.debug("Shard {} is initialized", (Object)this.shardId);
        this.actorInitialized = true;
        this.notifyOnShardInitializedCallbacks();
    }

    private void notifyOnShardInitializedCallbacks() {
        if (this.onShardInitializedSet.isEmpty()) {
            return;
        }
        boolean ready = this.isShardReadyWithLeaderId();
        String readyStr = ready ? "ready" : "initialized";
        LOG.debug("Shard {} is {} - notifying {} OnShardInitialized callbacks", new Object[]{this.shardId, readyStr, this.onShardInitializedSet.size()});
        Iterator<ShardManager.OnShardInitialized> iter = this.onShardInitializedSet.iterator();
        while (iter.hasNext()) {
            ShardManager.OnShardInitialized onShardInitialized = iter.next();
            if (onShardInitialized instanceof ShardManager.OnShardReady && !ready) continue;
            iter.remove();
            onShardInitialized.getTimeoutSchedule().cancel();
            onShardInitialized.getReplyRunnable().run();
        }
    }

    void addOnShardInitialized(ShardManager.OnShardInitialized onShardInitialized) {
        this.onShardInitializedSet.add(onShardInitialized);
    }

    void removeOnShardInitialized(ShardManager.OnShardInitialized onShardInitialized) {
        this.onShardInitializedSet.remove(onShardInitialized);
    }

    void setRole(String newRole) {
        this.role = newRole;
        this.notifyOnShardInitializedCallbacks();
    }

    String getRole() {
        return this.role;
    }

    void setFollowerSyncStatus(boolean syncStatus) {
        this.followerSyncStatus = syncStatus;
    }

    boolean isInSync() {
        if (RaftState.Follower.name().equals(this.role)) {
            return this.followerSyncStatus;
        }
        return RaftState.Leader.name().equals(this.role);
    }

    boolean setLeaderId(String newLeaderId) {
        boolean changed = !Objects.equals(this.leaderId, newLeaderId);
        this.leaderId = newLeaderId;
        if (newLeaderId != null) {
            this.leaderAvailable = true;
        }
        this.notifyOnShardInitializedCallbacks();
        return changed;
    }

    String getLeaderId() {
        return this.leaderId;
    }

    void setLeaderAvailable(boolean leaderAvailable) {
        this.leaderAvailable = leaderAvailable;
        if (leaderAvailable) {
            this.notifyOnShardInitializedCallbacks();
        }
    }

    short getLeaderVersion() {
        return this.leaderVersion;
    }

    void setLeaderVersion(short leaderVersion) {
        this.leaderVersion = leaderVersion;
    }

    boolean isActiveMember() {
        return this.activeMember;
    }

    void setActiveMember(boolean isActiveMember) {
        this.activeMember = isActiveMember;
    }

    EffectiveModelContext getSchemaContext() {
        return this.schemaContextProvider.getEffectiveModelContext();
    }

    void setSchemaContext(EffectiveModelContext schemaContext) {
        this.schemaContextProvider.set(Objects.requireNonNull(schemaContext));
    }

    @VisibleForTesting
    Shard.AbstractBuilder<?, ?> getBuilder() {
        return this.builder;
    }

    public String toString() {
        return "ShardInformation [shardId=" + this.shardId + ", leaderAvailable=" + this.leaderAvailable + ", actorInitialized=" + this.actorInitialized + ", followerSyncStatus=" + this.followerSyncStatus + ", role=" + this.role + ", leaderId=" + this.leaderId + ", activeMember=" + this.activeMember + "]";
    }
}

