/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.NormalizedNodeAggregator;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;

public final class RootScatterGather {
    private RootScatterGather() {
    }

    public static @NonNull ContainerNode castRootNode(NormalizedNode node) {
        NormalizedNode nonnull = Objects.requireNonNull(node);
        Preconditions.checkArgument((boolean)(nonnull instanceof ContainerNode), (String)"Invalid root data %s", (Object)nonnull);
        return (ContainerNode)nonnull;
    }

    public static @NonNull FluentFuture<Optional<NormalizedNode>> gather(ActorUtils actorUtils, Stream<FluentFuture<Optional<NormalizedNode>>> readFutures) {
        return FluentFuture.from((ListenableFuture)Futures.transform((ListenableFuture)Futures.allAsList((Iterable)((Iterable)readFutures.collect(ImmutableList.toImmutableList()))), input -> {
            try {
                return NormalizedNodeAggregator.aggregate(YangInstanceIdentifier.of(), input, actorUtils.getSchemaContext(), actorUtils.getDatastoreContext().getLogicalStoreType());
            }
            catch (DataValidationFailedException e) {
                throw new IllegalArgumentException("Failed to aggregate", e);
            }
        }, (Executor)MoreExecutors.directExecutor()));
    }

    public static <T> @NonNull Stream<ShardContainer<T>> scatterAll(ContainerNode rootNode, Function<YangInstanceIdentifier.PathArgument, T> childToShard, Stream<T> allShards) {
        Map builders = allShards.collect(Collectors.toUnmodifiableMap(Function.identity(), unused -> Builders.containerBuilder()));
        for (DataContainerChild child : rootNode.body()) {
            T shard = childToShard.apply((YangInstanceIdentifier.PathArgument)child.name());
            ((DataContainerNodeBuilder)Verify.verifyNotNull((Object)builders.get(shard), (String)"Failed to find builder for %s", (Object[])new Object[]{shard})).addChild((NormalizedNode)child);
        }
        return RootScatterGather.streamContainers(rootNode.name(), builders);
    }

    public static <T> @NonNull Stream<ShardContainer<T>> scatterTouched(ContainerNode rootNode, Function<YangInstanceIdentifier.PathArgument, T> childToShard) {
        HashMap<Object, DataContainerNodeBuilder> builders = new HashMap<Object, DataContainerNodeBuilder>();
        for (DataContainerChild child : rootNode.body()) {
            builders.computeIfAbsent(childToShard.apply((YangInstanceIdentifier.PathArgument)child.name()), unused -> Builders.containerBuilder()).addChild((NormalizedNode)child);
        }
        return RootScatterGather.streamContainers(rootNode.name(), builders);
    }

    private static <T> @NonNull Stream<ShardContainer<T>> streamContainers(YangInstanceIdentifier.NodeIdentifier rootId, Map<T, DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>> builders) {
        return builders.entrySet().stream().map(entry -> new ShardContainer(entry.getKey(), (ContainerNode)((DataContainerNodeBuilder)entry.getValue()).withNodeIdentifier((YangInstanceIdentifier.PathArgument)rootId).build()));
    }

    @NonNullByDefault
    public static final class ShardContainer<T> {
        private final ContainerNode container;
        private final T shard;

        ShardContainer(T shard, ContainerNode container) {
            this.shard = Objects.requireNonNull(shard);
            this.container = Objects.requireNonNull(container);
        }

        public T shard() {
            return this.shard;
        }

        public ContainerNode container() {
            return this.container;
        }

        public int hashCode() {
            return this.shard.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj == this || obj instanceof ShardContainer && this.shard.equals(((ShardContainer)obj).shard);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("shard", this.shard).toString();
        }
    }
}

