/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.eos.akka.AkkaEntityOwnershipService;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListenerRegistration;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;

final class ListenerRegistration
extends AbstractObjectRegistration<DOMEntityOwnershipListener>
implements DOMEntityOwnershipListenerRegistration {
    private final AkkaEntityOwnershipService service;
    private final @NonNull String entityType;

    ListenerRegistration(DOMEntityOwnershipListener listener, String entityType, AkkaEntityOwnershipService service) {
        super((Object)listener);
        this.entityType = Objects.requireNonNull(entityType);
        this.service = Objects.requireNonNull(service);
    }

    public String getEntityType() {
        return this.entityType;
    }

    protected void removeRegistration() {
        this.service.unregisterListener(this.entityType, (DOMEntityOwnershipListener)this.getInstance());
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("entityType", (Object)this.entityType);
    }
}

