/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.checker.command;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.eos.akka.owner.checker.command.StateCheckerReply;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityBackendReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.GetEntityOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.GetEntityOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.NodeName;

public final class GetEntityReply
extends StateCheckerReply
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableSet<String> candidates;
    private final String owner;

    public GetEntityReply(GetEntityBackendReply backendReply) {
        this.candidates = backendReply.getCandidates();
        this.owner = backendReply.getOwner();
    }

    public GetEntityReply(@Nullable String owner, @Nullable Set<String> candidates) {
        this.owner = owner;
        this.candidates = candidates == null ? ImmutableSet.of() : ImmutableSet.copyOf(candidates);
    }

    public @NonNull GetEntityOutput toOutput() {
        GetEntityOutputBuilder builder = new GetEntityOutputBuilder();
        if (this.owner != null) {
            builder.setOwnerNode(new NodeName(this.owner));
        }
        return builder.setCandidateNodes(this.candidates.stream().map(NodeName::new).collect(Collectors.toUnmodifiableList())).build();
    }
}

