/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.supervisor;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.cluster.ddata.ORMap;
import akka.cluster.ddata.ORSet;
import akka.cluster.ddata.typed.javadsl.DistributedData;
import akka.cluster.ddata.typed.javadsl.Replicator;
import akka.cluster.ddata.typed.javadsl.ReplicatorMessageAdapter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import org.opendaylight.controller.eos.akka.owner.supervisor.CandidateCleaner;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidates;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidatesForMember;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidatesResponse;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorCommand;
import org.opendaylight.controller.eos.akka.registry.candidate.CandidateRegistry;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.slf4j.Logger;

abstract class AbstractSupervisor
extends AbstractBehavior<OwnerSupervisorCommand> {
    final ReplicatorMessageAdapter<OwnerSupervisorCommand, ORMap<DOMEntity, ORSet<String>>> candidateReplicator;

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="getContext() is non-final")
    AbstractSupervisor(ActorContext<OwnerSupervisorCommand> context) {
        super(context);
        ActorRef replicator = DistributedData.get((ActorSystem)this.getContext().getSystem()).replicator();
        this.candidateReplicator = new ReplicatorMessageAdapter(this.getContext(), replicator, Duration.ofSeconds(5L));
    }

    Behavior<OwnerSupervisorCommand> onClearCandidatesForMember(ClearCandidatesForMember command) {
        this.getLogger().debug("Clearing candidates for member: {}", (Object)command.getCandidate());
        this.candidateReplicator.askGet(askReplyTo -> new Replicator.Get(CandidateRegistry.KEY, (Replicator.ReadConsistency)new Replicator.ReadMajority(Duration.ofSeconds(15L)), askReplyTo), response -> new ClearCandidates((Replicator.GetResponse<ORMap<DOMEntity, ORSet<String>>>)response, command));
        return this;
    }

    Behavior<OwnerSupervisorCommand> finishClearCandidates(ClearCandidates command) {
        if (command.getResponse() instanceof Replicator.GetSuccess) {
            this.getLogger().debug("Retrieved candidate data, clearing candidates for {}", (Object)command.getOriginalMessage().getCandidate());
            this.getContext().spawnAnonymous(CandidateCleaner.create()).tell((Object)command);
        } else {
            this.getLogger().debug("Unable to retrieve candidate data for {}, no candidates present sending empty reply", (Object)command.getOriginalMessage().getCandidate());
            command.getOriginalMessage().getReplyTo().tell((Object)new ClearCandidatesResponse());
        }
        return this;
    }

    abstract Logger getLogger();
}

