/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.supervisor;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.cluster.ddata.Key;
import akka.cluster.ddata.LWWRegister;
import akka.cluster.ddata.LWWRegisterKey;
import akka.cluster.ddata.ORMap;
import akka.cluster.ddata.ORSet;
import akka.cluster.ddata.typed.javadsl.DistributedData;
import akka.cluster.ddata.typed.javadsl.Replicator;
import akka.cluster.ddata.typed.javadsl.ReplicatorMessageAdapter;
import akka.japi.function.Function;
import akka.pattern.StatusReply;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.eos.akka.owner.supervisor.AbstractSupervisor;
import org.opendaylight.controller.eos.akka.owner.supervisor.OwnerSupervisor;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidates;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidatesForMember;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.DataCenterActivated;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntitiesBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityOwnerBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.InitialCandidateSync;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.InitialOwnerSync;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorCommand;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorReply;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorRequest;
import org.opendaylight.controller.eos.akka.registry.candidate.CandidateRegistry;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OwnerSyncer
extends AbstractSupervisor {
    private static final Logger LOG = LoggerFactory.getLogger(OwnerSyncer.class);
    private final ReplicatorMessageAdapter<OwnerSupervisorCommand, LWWRegister<String>> ownerReplicator;
    private final Map<DOMEntity, Set<String>> currentCandidates = new HashMap<DOMEntity, Set<String>>();
    private final Map<DOMEntity, String> currentOwners = new HashMap<DOMEntity, String>();
    private final Map<String, DOMEntity> entityLookup = new HashMap<String, DOMEntity>();
    private final BindingInstanceIdentifierCodec iidCodec;
    private int toSync = -1;

    private OwnerSyncer(ActorContext<OwnerSupervisorCommand> context, @Nullable ActorRef<OwnerSupervisorReply> notifyDatacenterStarted, BindingInstanceIdentifierCodec iidCodec) {
        super(context);
        this.iidCodec = Objects.requireNonNull(iidCodec);
        LOG.debug("Starting candidate and owner sync");
        ActorRef replicator = DistributedData.get((ActorSystem)context.getSystem()).replicator();
        this.ownerReplicator = new ReplicatorMessageAdapter(context, replicator, Duration.ofSeconds(5L));
        this.candidateReplicator.askGet(askReplyTo -> new Replicator.Get(CandidateRegistry.KEY, Replicator.readLocal(), askReplyTo), InitialCandidateSync::new);
        if (notifyDatacenterStarted != null) {
            notifyDatacenterStarted.tell((Object)DataCenterActivated.INSTANCE);
        }
    }

    public static Behavior<OwnerSupervisorCommand> create(ActorRef<OwnerSupervisorReply> notifyDatacenterStarted, BindingInstanceIdentifierCodec iidCodec) {
        return Behaviors.setup((Function & Serializable)ctx -> new OwnerSyncer((ActorContext<OwnerSupervisorCommand>)ctx, notifyDatacenterStarted, iidCodec));
    }

    public Receive<OwnerSupervisorCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(InitialCandidateSync.class, this::onInitialCandidateSync).onMessage(InitialOwnerSync.class, this::onInitialOwnerSync).onMessage(GetEntitiesBackendRequest.class, this::onFailEntityRpc).onMessage(GetEntityBackendRequest.class, this::onFailEntityRpc).onMessage(GetEntityOwnerBackendRequest.class, this::onFailEntityRpc).onMessage(ClearCandidatesForMember.class, this::onClearCandidatesForMember).onMessage(ClearCandidates.class, this::finishClearCandidates).build();
    }

    private Behavior<OwnerSupervisorCommand> onFailEntityRpc(OwnerSupervisorRequest message) {
        LOG.debug("Failing rpc request. {}", (Object)message);
        message.getReplyTo().tell((Object)StatusReply.error((String)"OwnerSupervisor is inactive so it cannot handle entity rpc requests."));
        return this;
    }

    private Behavior<OwnerSupervisorCommand> onInitialCandidateSync(InitialCandidateSync rsp) {
        Replicator.GetResponse<ORMap<DOMEntity, ORSet<String>>> response = rsp.getResponse();
        if (response instanceof Replicator.GetSuccess) {
            return this.doInitialSync((Replicator.GetSuccess<ORMap<DOMEntity, ORSet<String>>>)((Replicator.GetSuccess)response));
        }
        if (response instanceof Replicator.NotFound) {
            LOG.debug("No candidates found switching to supervisor");
            return this.switchToSupervisor();
        }
        LOG.debug("Initial candidate sync failed, switching to supervisor. Sync reply: {}", response);
        return this.switchToSupervisor();
    }

    private Behavior<OwnerSupervisorCommand> doInitialSync(Replicator.GetSuccess<ORMap<DOMEntity, ORSet<String>>> response) {
        ORMap candidates = (ORMap)response.get(CandidateRegistry.KEY);
        candidates.getEntries().entrySet().forEach(entry -> this.currentCandidates.put((DOMEntity)entry.getKey(), new HashSet(((ORSet)entry.getValue()).getElements())));
        this.toSync = candidates.keys().size();
        for (DOMEntity entity : candidates.keys().getElements()) {
            this.entityLookup.put(entity.toString(), entity);
            this.ownerReplicator.askGet(askReplyTo -> new Replicator.Get((Key)new LWWRegisterKey(entity.toString()), Replicator.readLocal(), askReplyTo), InitialOwnerSync::new);
        }
        return this;
    }

    private Behavior<OwnerSupervisorCommand> onInitialOwnerSync(InitialOwnerSync rsp) {
        Replicator.GetResponse<LWWRegister<String>> response = rsp.getResponse();
        if (response instanceof Replicator.GetSuccess) {
            this.handleOwnerRsp((Replicator.GetSuccess<LWWRegister<String>>)((Replicator.GetSuccess)response));
        } else if (response instanceof Replicator.NotFound) {
            OwnerSyncer.handleNotFoundOwnerRsp((Replicator.NotFound<LWWRegister<String>>)((Replicator.NotFound)response));
        } else {
            LOG.debug("Initial sync failed response: {}", response);
        }
        --this.toSync;
        if (this.toSync == 0) {
            return this.switchToSupervisor();
        }
        return this;
    }

    private Behavior<OwnerSupervisorCommand> switchToSupervisor() {
        LOG.debug("Initial sync done, switching to supervisor. candidates: {}, owners: {}", this.currentCandidates, this.currentOwners);
        return Behaviors.setup((Function & Serializable)ctx -> OwnerSupervisor.create(this.currentCandidates, this.currentOwners, this.iidCodec));
    }

    private void handleOwnerRsp(Replicator.GetSuccess<LWWRegister<String>> rsp) {
        DOMEntity entity = this.entityLookup.get(rsp.key().id());
        String owner = (String)((LWWRegister)rsp.get(rsp.key())).getValue();
        this.currentOwners.put(entity, owner);
    }

    private static void handleNotFoundOwnerRsp(Replicator.NotFound<LWWRegister<String>> rsp) {
        LOG.debug("Owner not found. {}", rsp);
    }

    @Override
    Logger getLogger() {
        return LOG;
    }
}

