/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.get.entities.output;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.Candidates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.Details;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.NodeName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.Owner;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.get.entities.output.Entities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.get.entities.output.EntitiesKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EntitiesBuilder {
    private List<NodeName> _candidateNodes;
    private EntityName _name;
    private NodeName _ownerNode;
    private EntityType _type;
    private EntitiesKey key;
    Map<Class<? extends Augmentation<Entities>>, Augmentation<Entities>> augmentation = Map.of();

    public EntitiesBuilder() {
    }

    public EntitiesBuilder(EntityId arg) {
        this._type = arg.getType();
        this._name = arg.getName();
    }

    public EntitiesBuilder(Details arg) {
        this._ownerNode = arg.getOwnerNode();
        this._candidateNodes = arg.getCandidateNodes();
    }

    public EntitiesBuilder(Owner arg) {
        this._ownerNode = arg.getOwnerNode();
    }

    public EntitiesBuilder(Candidates arg) {
        this._candidateNodes = arg.getCandidateNodes();
    }

    public EntitiesBuilder(Entities base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entities>>, Augmentation<Entities>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._type = base.getType();
        this._candidateNodes = base.getCandidateNodes();
        this._ownerNode = base.getOwnerNode();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof EntityId) {
            castArg = (EntityId)arg;
            this._type = castArg.getType();
            this._name = castArg.getName();
            isValidArg = true;
        }
        if (arg instanceof Owner) {
            castArg = (Owner)arg;
            this._ownerNode = castArg.getOwnerNode();
            isValidArg = true;
        }
        if (arg instanceof Details) {
            castArg = (Details)arg;
            isValidArg = true;
        }
        if (arg instanceof Candidates) {
            castArg = (Candidates)arg;
            this._candidateNodes = castArg.getCandidateNodes();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[EntityId, Owner, Details, Candidates]");
    }

    public EntitiesKey key() {
        return this.key;
    }

    public List<NodeName> getCandidateNodes() {
        return this._candidateNodes;
    }

    public EntityName getName() {
        return this._name;
    }

    public NodeName getOwnerNode() {
        return this._ownerNode;
    }

    public EntityType getType() {
        return this._type;
    }

    public <E$$ extends Augmentation<Entities>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public EntitiesBuilder withKey(EntitiesKey key) {
        this.key = key;
        return this;
    }

    public EntitiesBuilder setCandidateNodes(List<NodeName> values) {
        this._candidateNodes = values;
        return this;
    }

    public EntitiesBuilder setName(EntityName value) {
        this._name = value;
        return this;
    }

    public EntitiesBuilder setOwnerNode(NodeName value) {
        this._ownerNode = value;
        return this;
    }

    public EntitiesBuilder setType(EntityType value) {
        this._type = value;
        return this;
    }

    public EntitiesBuilder addAugmentation(Augmentation<Entities> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entities>>, Augmentation<Entities>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public EntitiesBuilder removeAugmentation(Class<? extends Augmentation<Entities>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Entities build() {
        return new EntitiesImpl(this);
    }

    private static final class EntitiesImpl
    extends AbstractAugmentable<Entities>
    implements Entities {
        private final List<NodeName> _candidateNodes;
        private final EntityName _name;
        private final NodeName _ownerNode;
        private final EntityType _type;
        private final EntitiesKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EntitiesImpl(EntitiesBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new EntitiesKey(base.getName(), base.getType());
            this._name = this.key.getName();
            this._type = this.key.getType();
            this._candidateNodes = base.getCandidateNodes();
            this._ownerNode = base.getOwnerNode();
        }

        @Override
        public EntitiesKey key() {
            return this.key;
        }

        @Override
        public List<NodeName> getCandidateNodes() {
            return this._candidateNodes;
        }

        @Override
        public EntityName getName() {
            return this._name;
        }

        @Override
        public NodeName getOwnerNode() {
            return this._ownerNode;
        }

        @Override
        public EntityType getType() {
            return this._type;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Entities.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Entities.bindingEquals(this, obj);
        }

        public String toString() {
            return Entities.bindingToString(this);
        }
    }
}

