/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.extension;

import java.util.Arrays;
import org.apache.karaf.features.extension.StoredWiringResolver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.FrameworkWiring;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final String WIRING_PATH = "wiring";
    private StoredWiringResolver resolver;
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.resolver = new StoredWiringResolver(context.getDataFile(WIRING_PATH).toPath());
        context.addBundleListener((BundleListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getBundle().getBundleId() == 0L && event.getType() == 2) {
            this.resolveAll();
        } else if (event.getType() == 32) {
            this.resolver.update(event.getBundle());
        } else if (event.getType() == 64) {
            this.resolver.delete(event.getBundle());
        }
    }

    private void resolveAll() {
        ServiceRegistration registration = this.context.registerService(ResolverHookFactory.class, triggers -> this.resolver, null);
        try {
            ((FrameworkWiring)this.context.getBundle().adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(this.context.getBundles()));
        }
        finally {
            registration.unregister();
        }
    }
}

