/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ModifiableMapPhase;
import org.opendaylight.yangtools.util.MutableOffsetMap;
import org.opendaylight.yangtools.util.SingletonSet;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class SharedSingletonMap<K, V>
implements Serializable,
UnmodifiableMapPhase<K, V> {
    private static final long serialVersionUID = 1L;
    private static final LoadingCache<Object, SingletonSet<Object>> CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Object, SingletonSet<Object>>(){

        public SingletonSet<Object> load(Object key) {
            return SingletonSet.of(key);
        }
    });
    private final @NonNull SingletonSet<K> keySet;
    private final @NonNull V value;
    private int hashCode;

    private SharedSingletonMap(SingletonSet<K> keySet, V value) {
        this.keySet = Objects.requireNonNull(keySet);
        this.value = Objects.requireNonNull(value);
    }

    private SharedSingletonMap(K key, V value) {
        this(SharedSingletonMap.cachedSet(key), value);
    }

    public static <K, V> @NonNull SharedSingletonMap<K, V> orderedOf(K key, V value) {
        return new Ordered<K, V>(key, value);
    }

    public static <K, V> @NonNull SharedSingletonMap<K, V> unorderedOf(K key, V value) {
        return new Unordered<K, V>(key, value);
    }

    public static <K, V> @NonNull SharedSingletonMap<K, V> orderedCopyOf(Map<K, V> map) {
        Map.Entry<K, V> e = SharedSingletonMap.singleEntry(map);
        return new Ordered<K, V>(e.getKey(), e.getValue());
    }

    public static <K, V> @NonNull SharedSingletonMap<K, V> unorderedCopyOf(Map<K, V> map) {
        Map.Entry<K, V> e = SharedSingletonMap.singleEntry(map);
        return new Unordered<K, V>(e.getKey(), e.getValue());
    }

    public final Map.Entry<K, V> getEntry() {
        return new AbstractMap.SimpleImmutableEntry<K, V>(this.keySet.getElement(), this.value);
    }

    @Override
    public final @NonNull SingletonSet<Map.Entry<K, V>> entrySet() {
        return SingletonSet.of(this.getEntry());
    }

    @Override
    public final @NonNull SingletonSet<K> keySet() {
        return this.keySet;
    }

    @Override
    public final @NonNull SingletonSet<V> values() {
        return SingletonSet.of(this.value);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.keySet.contains(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.value.equals(value);
    }

    @Override
    public final V get(Object key) {
        return this.keySet.contains(key) ? (V)this.value : null;
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.keySet.getElement().hashCode() ^ this.value.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        return m.size() == 1 && this.value.equals(m.get(this.keySet.getElement()));
    }

    public final String toString() {
        return "{" + this.keySet.getElement() + "=" + this.value + "}";
    }

    static <K> @NonNull SingletonSet<K> cachedSet(K key) {
        return (SingletonSet)CACHE.getUnchecked(key);
    }

    private static <K, V> Map.Entry<K, V> singleEntry(Map<K, V> map) {
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"Input map is empty");
        Map.Entry<K, V> ret = it.next();
        Preconditions.checkArgument((!it.hasNext() ? 1 : 0) != 0, (Object)"Input map has more than one entry");
        return ret;
    }

    static final class Ordered<K, V>
    extends SharedSingletonMap<K, V> {
        private static final long serialVersionUID = 1L;

        Ordered(K key, V value) {
            super(key, value);
        }

        Ordered(SingletonSet<K> keySet, V value) {
            super(keySet, value);
        }

        @Override
        public @NonNull ModifiableMapPhase<K, V> toModifiableMap() {
            return MutableOffsetMap.orderedCopyOf(this);
        }
    }

    static final class Unordered<K, V>
    extends SharedSingletonMap<K, V> {
        private static final long serialVersionUID = 1L;

        Unordered(K key, V value) {
            super(key, value);
        }

        Unordered(SingletonSet<K> keySet, V value) {
            super(keySet, value);
        }

        @Override
        public @NonNull ModifiableMapPhase<K, V> toModifiableMap() {
            return MutableOffsetMap.unorderedCopyOf(this);
        }
    }
}

