/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;

@Beta
@NonNullByDefault
public final class FluentFutures {
    private static final FluentFuture<?> CANCELLED_FUTURE = FluentFuture.from((ListenableFuture)Futures.immediateCancelledFuture());
    private static final FluentFuture<?> NULL_FUTURE = FluentFuture.from((ListenableFuture)Futures.immediateFuture(null));
    private static final FluentFuture<Boolean> FALSE_FUTURE = FluentFuture.from((ListenableFuture)Futures.immediateFuture((Object)Boolean.FALSE));
    private static final FluentFuture<Boolean> TRUE_FUTURE = FluentFuture.from((ListenableFuture)Futures.immediateFuture((Object)Boolean.TRUE));

    private FluentFutures() {
    }

    public static <T> FluentFuture<T> immediateCancelledFluentFuture() {
        return CANCELLED_FUTURE;
    }

    public static <T> FluentFuture<T> immediateFailedFluentFuture(Throwable cause) {
        return FluentFuture.from((ListenableFuture)Futures.immediateFailedFuture((Throwable)Objects.requireNonNull(cause)));
    }

    public static <T> FluentFuture<T> immediateFluentFuture(T result) {
        return FluentFuture.from((ListenableFuture)Futures.immediateFuture(Objects.requireNonNull(result)));
    }

    public static <T> FluentFuture<T> immediateNullFluentFuture() {
        return NULL_FUTURE;
    }

    public static FluentFuture<Boolean> immediateBooleanFluentFuture(Boolean result) {
        return FluentFutures.immediateBooleanFluentFuture((boolean)result);
    }

    public static FluentFuture<Boolean> immediateBooleanFluentFuture(boolean result) {
        return result ? TRUE_FUTURE : FALSE_FUTURE;
    }

    public static FluentFuture<Boolean> immediateTrueFluentFuture() {
        return TRUE_FUTURE;
    }

    public static FluentFuture<Boolean> immediateFalseFluentFuture() {
        return FALSE_FUTURE;
    }
}

