/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.util.concurrent.ThreadFactoryProvider;
import org.slf4j.Logger;

@SuppressFBWarnings
public final class ImmutableThreadFactoryProvider
extends ThreadFactoryProvider {
    private final String namePrefix;
    private final Logger logger;
    private final Integer priority;
    private final boolean daemon;

    private ImmutableThreadFactoryProvider(String namePrefix, Logger logger, Optional<Integer> priority) {
        this.namePrefix = Objects.requireNonNull(namePrefix, "namePrefix");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.priority = priority.orElse(null);
        this.daemon = super.daemon();
    }

    private ImmutableThreadFactoryProvider(Builder builder) {
        this.namePrefix = builder.namePrefix;
        this.logger = builder.logger;
        this.priority = builder.priority;
        this.daemon = builder.daemonIsSet() ? builder.daemon : super.daemon();
    }

    private ImmutableThreadFactoryProvider(String namePrefix, Logger logger, Integer priority, boolean daemon) {
        this.namePrefix = namePrefix;
        this.logger = logger;
        this.priority = priority;
        this.daemon = daemon;
    }

    @Override
    public String namePrefix() {
        return this.namePrefix;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public Optional<Integer> priority() {
        return Optional.ofNullable(this.priority);
    }

    @Override
    public boolean daemon() {
        return this.daemon;
    }

    public final ImmutableThreadFactoryProvider withNamePrefix(String value) {
        String newValue = Objects.requireNonNull(value, "namePrefix");
        if (this.namePrefix.equals(newValue)) {
            return this;
        }
        return new ImmutableThreadFactoryProvider(newValue, this.logger, this.priority, this.daemon);
    }

    public final ImmutableThreadFactoryProvider withLogger(Logger value) {
        if (this.logger == value) {
            return this;
        }
        Logger newValue = Objects.requireNonNull(value, "logger");
        return new ImmutableThreadFactoryProvider(this.namePrefix, newValue, this.priority, this.daemon);
    }

    public final ImmutableThreadFactoryProvider withPriority(int value) {
        Integer newValue = value;
        if (Objects.equals(this.priority, newValue)) {
            return this;
        }
        return new ImmutableThreadFactoryProvider(this.namePrefix, this.logger, newValue, this.daemon);
    }

    public final ImmutableThreadFactoryProvider withPriority(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.priority, value)) {
            return this;
        }
        return new ImmutableThreadFactoryProvider(this.namePrefix, this.logger, value, this.daemon);
    }

    public final ImmutableThreadFactoryProvider withDaemon(boolean value) {
        if (this.daemon == value) {
            return this;
        }
        return new ImmutableThreadFactoryProvider(this.namePrefix, this.logger, this.priority, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableThreadFactoryProvider && this.equalTo(0, (ImmutableThreadFactoryProvider)another);
    }

    private boolean equalTo(int synthetic, ImmutableThreadFactoryProvider another) {
        return this.namePrefix.equals(another.namePrefix) && this.logger.equals(another.logger) && Objects.equals(this.priority, another.priority) && this.daemon == another.daemon;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.namePrefix.hashCode();
        h += (h << 5) + this.logger.hashCode();
        h += (h << 5) + Objects.hashCode(this.priority);
        h += (h << 5) + Booleans.hashCode((boolean)this.daemon);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ThreadFactoryProvider").omitNullValues().add("namePrefix", (Object)this.namePrefix).add("logger", (Object)this.logger).add("priority", (Object)this.priority).add("daemon", this.daemon).toString();
    }

    public static ImmutableThreadFactoryProvider of(String namePrefix, Logger logger, Optional<Integer> priority) {
        return new ImmutableThreadFactoryProvider(namePrefix, logger, priority);
    }

    public static ImmutableThreadFactoryProvider copyOf(ThreadFactoryProvider instance) {
        if (instance instanceof ImmutableThreadFactoryProvider) {
            return (ImmutableThreadFactoryProvider)instance;
        }
        return ((Builder)((Builder)ImmutableThreadFactoryProvider.builder()).namePrefix(instance.namePrefix()).logger(instance.logger()).priority((Optional)instance.priority())).daemon(instance.daemon()).build();
    }

    public static NamePrefixBuildStage builder() {
        return new Builder();
    }

    public static final class Builder
    implements NamePrefixBuildStage,
    LoggerBuildStage,
    BuildFinal {
        private static final long INIT_BIT_NAME_PREFIX = 1L;
        private static final long INIT_BIT_LOGGER = 2L;
        private static final long OPT_BIT_PRIORITY = 1L;
        private static final long OPT_BIT_DAEMON = 2L;
        private long initBits = 3L;
        private long optBits;
        private String namePrefix;
        private Logger logger;
        private Integer priority;
        private boolean daemon;

        private Builder() {
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            Builder.checkNotIsSet(this.namePrefixIsSet(), "namePrefix");
            this.namePrefix = Objects.requireNonNull(namePrefix, "namePrefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder logger(Logger logger) {
            Builder.checkNotIsSet(this.loggerIsSet(), "logger");
            this.logger = Objects.requireNonNull(logger, "logger");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder priority(int priority) {
            Builder.checkNotIsSet(this.priorityIsSet(), "priority");
            this.priority = priority;
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder priority(Optional<Integer> priority) {
            Builder.checkNotIsSet(this.priorityIsSet(), "priority");
            this.priority = priority.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder daemon(boolean daemon) {
            Builder.checkNotIsSet(this.daemonIsSet(), "daemon");
            this.daemon = daemon;
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutableThreadFactoryProvider build() {
            this.checkRequiredAttributes();
            return new ImmutableThreadFactoryProvider(this);
        }

        private boolean priorityIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean daemonIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean namePrefixIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean loggerIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ThreadFactoryProvider is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.namePrefixIsSet()) {
                attributes.add("namePrefix");
            }
            if (!this.loggerIsSet()) {
                attributes.add("logger");
            }
            return "Cannot build ThreadFactoryProvider, some of required attributes are not set " + attributes;
        }
    }

    public static interface NamePrefixBuildStage {
        public LoggerBuildStage namePrefix(String var1);
    }

    public static interface BuildFinal {
        public BuildFinal priority(int var1);

        public BuildFinal priority(Optional<Integer> var1);

        public BuildFinal daemon(boolean var1);

        public ImmutableThreadFactoryProvider build();
    }

    public static interface LoggerBuildStage {
        public BuildFinal logger(Logger var1);
    }
}

