/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.HierarchicalIdentifier;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifierV3;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public class InstanceIdentifier<T extends DataObject>
implements HierarchicalIdentifier<InstanceIdentifier<? extends DataObject>> {
    private static final long serialVersionUID = 3L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled through Externalizable proxy")
    final Iterable<PathArgument> pathArguments;
    private final @NonNull Class<T> targetType;
    private final boolean wildcarded;
    private final int hash;

    InstanceIdentifier(Class<T> type, Iterable<PathArgument> pathArguments, boolean wildcarded, int hash) {
        this.pathArguments = Objects.requireNonNull(pathArguments);
        this.targetType = Objects.requireNonNull(type);
        this.wildcarded = wildcarded;
        this.hash = hash;
    }

    public final @NonNull Class<T> getTargetType() {
        return this.targetType;
    }

    public final <N extends DataObject> @NonNull InstanceIdentifier<N> verifyTarget(Class<@NonNull N> target) {
        Verify.verify((boolean)target.equals(this.targetType), (String)"Cannot adapt %s to %s", (Object)this, target);
        return this;
    }

    public final @NonNull Iterable<PathArgument> getPathArguments() {
        return Iterables.unmodifiableIterable(this.pathArguments);
    }

    public final boolean isWildcarded() {
        return this.wildcarded;
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceIdentifier other = (InstanceIdentifier)obj;
        if (this.pathArguments == other.pathArguments) {
            return true;
        }
        if (this.hash != other.hash) {
            return false;
        }
        if (this.wildcarded != other.wildcarded) {
            return false;
        }
        if (this.targetType != other.targetType) {
            return false;
        }
        if (this.fastNonEqual(other)) {
            return false;
        }
        return Iterables.elementsEqual(this.pathArguments, other.pathArguments);
    }

    protected boolean fastNonEqual(InstanceIdentifier<?> other) {
        return false;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("targetType", this.targetType).add("path", (Object)Iterables.toString(this.pathArguments));
    }

    public final <I extends DataObject> @Nullable InstanceIdentifier<I> firstIdentifierOf(Class<@NonNull I> type) {
        int count = 1;
        for (PathArgument a : this.pathArguments) {
            if (type.equals(a.getType())) {
                InstanceIdentifier<?> ret = InstanceIdentifier.internalCreate(Iterables.limit(this.pathArguments, (int)count));
                return ret;
            }
            ++count;
        }
        return null;
    }

    public final <N extends KeyAware<K> & DataObject, K extends Key<N>> @Nullable K firstKeyOf(Class<@NonNull N> listItem) {
        for (PathArgument i : this.pathArguments) {
            if (!listItem.equals(i.getType())) continue;
            Object ret = ((IdentifiableItem)i).getKey();
            return (K)ret;
        }
        return null;
    }

    public final boolean contains(InstanceIdentifier<? extends DataObject> other) {
        Objects.requireNonNull(other, "other should not be null");
        Iterator<PathArgument> oit = other.pathArguments.iterator();
        for (PathArgument pathArgument : this.pathArguments) {
            if (!oit.hasNext()) {
                return false;
            }
            if (pathArgument.equals(oit.next())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsWildcarded(InstanceIdentifier<?> other) {
        Objects.requireNonNull(other, "other should not be null");
        Iterator<PathArgument> oit = other.pathArguments.iterator();
        for (PathArgument la : this.pathArguments) {
            if (!oit.hasNext()) {
                return false;
            }
            PathArgument oa = oit.next();
            if (!la.getType().equals(oa.getType())) {
                return false;
            }
            if (!(la instanceof IdentifiableItem) || !(oa instanceof IdentifiableItem) || la.equals(oa)) continue;
            return false;
        }
        return true;
    }

    private <N extends DataObject> @NonNull InstanceIdentifier<N> childIdentifier(AbstractPathArgument<N> arg) {
        return InstanceIdentifier.trustedCreate(arg, Iterables.concat(this.pathArguments, Collections.singleton(arg)), HashCodeBuilder.nextHashCode((int)this.hash, arg), this.wildcarded);
    }

    public final <N extends ChildOf<? super T>> @NonNull InstanceIdentifier<N> child(Class<@NonNull N> container) {
        return this.childIdentifier(Item.of(container));
    }

    public final <N extends KeyAware<K> & ChildOf<? super T>, K extends Key<N>> @NonNull KeyedInstanceIdentifier<N, K> child(Class<@NonNull N> listItem, K listKey) {
        return (KeyedInstanceIdentifier)this.childIdentifier(IdentifiableItem.of(listItem, listKey));
    }

    public final <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> @NonNull InstanceIdentifier<N> child(Class<@NonNull C> caze, Class<@NonNull N> container) {
        return this.childIdentifier(Item.of(caze, container));
    }

    public final <C extends ChoiceIn<? super T> & DataObject, K extends Key<N>, N extends KeyAware<K> & ChildOf<? super C>> @NonNull KeyedInstanceIdentifier<N, K> child(Class<@NonNull C> caze, Class<@NonNull N> listItem, K listKey) {
        return (KeyedInstanceIdentifier)this.childIdentifier(IdentifiableItem.of(caze, listItem, listKey));
    }

    public final <N extends DataObject & Augmentation<? super T>> @NonNull InstanceIdentifier<N> augmentation(Class<@NonNull N> container) {
        return this.childIdentifier(Item.of(container));
    }

    private Object writeReplace() throws ObjectStreamException {
        return new InstanceIdentifierV3(this);
    }

    public @NonNull Builder<T> builder() {
        return new RegularBuilder(this);
    }

    public static <T extends ChildOf<? extends DataRoot>> @NonNull Builder<T> builder(Class<T> container) {
        return new RegularBuilder<T>(Item.of(container));
    }

    public static <C extends ChoiceIn<? extends DataRoot> & DataObject, T extends ChildOf<? super C>> @NonNull Builder<T> builder(Class<C> caze, Class<T> container) {
        return new RegularBuilder<T>(Item.of(caze, container));
    }

    public static <N extends KeyAware<K> & ChildOf<? extends DataRoot>, K extends Key<N>> @NonNull KeyedBuilder<N, K> builder(Class<N> listItem, K listKey) {
        return new KeyedBuilder<N, K>(IdentifiableItem.of(listItem, listKey));
    }

    public static <C extends ChoiceIn<? extends DataRoot> & DataObject, N extends KeyAware<K> & ChildOf<? super C>, K extends Key<N>> @NonNull KeyedBuilder<N, K> builder(Class<C> caze, Class<N> listItem, K listKey) {
        return new KeyedBuilder<N, K>(IdentifiableItem.of(caze, listItem, listKey));
    }

    public static <R extends DataRoot & DataObject, T extends ChildOf<? super R>> @NonNull Builder<T> builderOfInherited(Class<R> root, Class<T> container) {
        return new RegularBuilder<T>(Item.of(container));
    }

    public static <R extends DataRoot & DataObject, C extends ChoiceIn<? super R> & DataObject, T extends ChildOf<? super C>> @NonNull Builder<T> builderOfInherited(Class<R> root, Class<C> caze, Class<T> container) {
        return new RegularBuilder<T>(Item.of(caze, container));
    }

    public static <R extends DataRoot & DataObject, N extends KeyAware<K> & ChildOf<? super R>, K extends Key<N>> @NonNull KeyedBuilder<N, K> builderOfInherited(Class<R> root, Class<N> listItem, K listKey) {
        return new KeyedBuilder<N, K>(IdentifiableItem.of(listItem, listKey));
    }

    public static <R extends DataRoot & DataObject, C extends ChoiceIn<? super R> & DataObject, N extends KeyAware<K> & ChildOf<? super C>, K extends Key<N>> @NonNull KeyedBuilder<N, K> builderOfInherited(Class<R> root, Class<C> caze, Class<N> listItem, K listKey) {
        return new KeyedBuilder<N, K>(IdentifiableItem.of(caze, listItem, listKey));
    }

    private static @NonNull InstanceIdentifier<?> internalCreate(Iterable<PathArgument> pathArguments) {
        PathArgument arg;
        Iterator<PathArgument> it = Objects.requireNonNull(pathArguments, "pathArguments may not be null").iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"pathArguments may not be empty");
        HashCodeBuilder hashBuilder = new HashCodeBuilder();
        boolean wildcard = false;
        do {
            Class<? extends DataObject> type;
            Preconditions.checkArgument((ChildOf.class.isAssignableFrom(type = ((PathArgument)Verify.verifyNotNull((Object)(arg = it.next()))).getType()) || Augmentation.class.isAssignableFrom(type) ? 1 : 0) != 0, (String)"%s is not a valid path argument", type);
            hashBuilder.addArgument((Object)arg);
            if (!KeyAware.class.isAssignableFrom(type) || arg instanceof IdentifiableItem) continue;
            wildcard = true;
        } while (it.hasNext());
        return InstanceIdentifier.trustedCreate(arg, pathArguments, hashBuilder.build(), wildcard);
    }

    public static <T extends DataObject> @NonNull InstanceIdentifier<T> unsafeOf(List<? extends PathArgument> pathArguments) {
        return InstanceIdentifier.internalCreate((Iterable<PathArgument>)ImmutableList.copyOf(pathArguments));
    }

    public static <T extends ChildOf<? extends DataRoot>> @NonNull InstanceIdentifier<T> create(Class<@NonNull T> type) {
        return InstanceIdentifier.internalCreate((Iterable<PathArgument>)ImmutableList.of(Item.of(type)));
    }

    public static <N extends KeyAware<K> & DataObject, K extends Key<N>> K keyOf(InstanceIdentifier<N> id) {
        Objects.requireNonNull(id);
        Preconditions.checkArgument((boolean)(id instanceof KeyedInstanceIdentifier), (String)"%s does not have a key", id);
        Object ret = ((KeyedInstanceIdentifier)id).getKey();
        return ret;
    }

    static <N extends DataObject> @NonNull InstanceIdentifier<N> trustedCreate(PathArgument arg, Iterable<PathArgument> pathArguments, int hash, boolean wildcarded) {
        if (arg instanceof IdentifiableItem) {
            IdentifiableItem identifiable = (IdentifiableItem)arg;
            return new KeyedInstanceIdentifier<DataObject, Object>(arg.getType(), pathArguments, wildcarded, hash, identifiable.getKey());
        }
        Class<? extends DataObject> type = arg.getType();
        return new InstanceIdentifier<DataObject>(type, pathArguments, wildcarded || KeyAware.class.isAssignableFrom(type), hash);
    }

    public static interface PathArgument
    extends Comparable<PathArgument> {
        public @NonNull Class<? extends DataObject> getType();

        default public Optional<? extends Class<? extends DataObject>> getCaseType() {
            return Optional.empty();
        }
    }

    public static class IdentifiableItem<I extends KeyAware<T> & DataObject, T extends Key<I>>
    extends AbstractPathArgument<I> {
        private static final long serialVersionUID = 1L;
        private final @NonNull T key;

        IdentifiableItem(Class<I> type, T key) {
            super(type);
            this.key = (Key)Objects.requireNonNull(key, "Key may not be null.");
        }

        public static <T extends KeyAware<I> & DataObject, I extends Key<T>> @NonNull IdentifiableItem<T, I> of(Class<T> type, I key) {
            return new IdentifiableItem<T, I>(type, key);
        }

        public static <C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C> & KeyAware<I>, I extends Key<T>> @NonNull IdentifiableItem<T, I> of(Class<C> caseType, Class<T> type, I key) {
            return new CaseIdentifiableItem<C, T, I>(caseType, type, key);
        }

        @Override
        public final @NonNull T getKey() {
            return this.key;
        }

        public String toString() {
            return this.getType().getName() + "[key=" + this.key + "]";
        }
    }

    public static class Item<T extends DataObject>
    extends AbstractPathArgument<T> {
        private static final long serialVersionUID = 1L;

        Item(Class<T> type) {
            super(type);
        }

        public static <T extends DataObject> @NonNull Item<T> of(Class<T> type) {
            return new Item<T>(type);
        }

        public static <C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C>> @NonNull Item<T> of(Class<C> caseType, Class<T> type) {
            return new CaseItem<C, T>(caseType, type);
        }

        public String toString() {
            return this.getType().getName();
        }
    }

    private static abstract class AbstractPathArgument<T extends DataObject>
    implements PathArgument,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final @NonNull Class<T> type;

        AbstractPathArgument(Class<T> type) {
            this.type = Objects.requireNonNull(type, "Type may not be null.");
        }

        public final Class<T> getType() {
            return this.type;
        }

        Object getKey() {
            return null;
        }

        public final int hashCode() {
            return Objects.hash(this.type, this.getCaseType(), this.getKey());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof AbstractPathArgument)) return false;
            AbstractPathArgument other = (AbstractPathArgument)obj;
            if (!this.type.equals(other.type)) return false;
            if (!Objects.equals(this.getKey(), other.getKey())) return false;
            if (!this.getCaseType().equals(other.getCaseType())) return false;
            return true;
        }

        @Override
        public final int compareTo(PathArgument arg) {
            int cmp = AbstractPathArgument.compareClasses(this.type, arg.getType());
            if (cmp != 0) {
                return cmp;
            }
            Optional<? extends Class<? extends DataObject>> caseType = this.getCaseType();
            if (!caseType.isPresent()) {
                return arg.getCaseType().isPresent() ? -1 : 1;
            }
            Optional<? extends Class<? extends DataObject>> argCaseType = this.getCaseType();
            return argCaseType.isPresent() ? AbstractPathArgument.compareClasses(caseType.orElseThrow(), argCaseType.orElseThrow()) : 1;
        }

        private static int compareClasses(Class<?> first, Class<?> second) {
            return first.getCanonicalName().compareTo(second.getCanonicalName());
        }
    }

    private static final class RegularBuilder<T extends DataObject>
    extends Builder<T> {
        private @NonNull Class<T> type;

        RegularBuilder(Item<T> item) {
            super(item, KeyAware.class.isAssignableFrom(item.getType()));
            this.type = item.getType();
        }

        RegularBuilder(InstanceIdentifier<T> identifier) {
            super(identifier);
            this.type = identifier.getTargetType();
        }

        private RegularBuilder(KeyedBuilder<?, ?> prev, Item<T> item, boolean wildcard) {
            super(prev, item, wildcard);
            this.type = item.getType();
        }

        @Override
        public InstanceIdentifier<T> build() {
            return new InstanceIdentifier<T>(this.type, this.pathArguments(), this.wildcard(), this.hashCode());
        }

        @Override
        <X extends DataObject> RegularBuilder<X> append(Item<X> item, boolean isWildcard) {
            this.appendItem(item, isWildcard);
            this.type = item.getType();
            return this;
        }

        @Override
        <X extends DataObject & KeyAware<Y>, Y extends Key<X>> KeyedBuilder<X, Y> append(IdentifiableItem<X, Y> item) {
            return new KeyedBuilder<X, Y>(this, item);
        }
    }

    public static final class KeyedBuilder<T extends DataObject & KeyAware<K>, K extends Key<T>>
    extends Builder<T> {
        private @NonNull IdentifiableItem<T, K> lastItem;

        KeyedBuilder(IdentifiableItem<T, K> item) {
            super(item, false);
            this.lastItem = Objects.requireNonNull(item);
        }

        KeyedBuilder(KeyedInstanceIdentifier<T, K> identifier) {
            super(identifier);
            this.lastItem = IdentifiableItem.of(identifier.getTargetType(), identifier.getKey());
        }

        private KeyedBuilder(RegularBuilder<?> prev, IdentifiableItem<T, K> item) {
            super(prev, item, false);
            this.lastItem = Objects.requireNonNull(item);
        }

        public @NonNull KeyedInstanceIdentifier<T, K> build() {
            return new KeyedInstanceIdentifier(this.lastItem.getType(), this.pathArguments(), this.wildcard(), this.hashCode(), this.lastItem.getKey());
        }

        @Override
        <X extends DataObject> @NonNull RegularBuilder<X> append(Item<X> item, boolean isWildcard) {
            return new RegularBuilder<X>(this, item, isWildcard);
        }

        @Override
        <X extends DataObject & KeyAware<Y>, Y extends Key<X>> KeyedBuilder<X, Y> append(IdentifiableItem<X, Y> item) {
            this.appendItem(item, false);
            this.lastItem = item;
            return this;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Builder<T extends DataObject> {
        private final ImmutableList.Builder<PathArgument> pathBuilder;
        private final HashCodeBuilder<PathArgument> hashBuilder;
        private final Iterable<? extends PathArgument> basePath;
        private boolean wildcard;

        Builder(Builder<?> prev, PathArgument item, boolean isWildcard) {
            this.pathBuilder = prev.pathBuilder;
            this.hashBuilder = prev.hashBuilder;
            this.basePath = prev.basePath;
            this.wildcard = prev.wildcard;
            this.appendItem(item, isWildcard);
        }

        Builder(InstanceIdentifier<T> identifier) {
            this.pathBuilder = ImmutableList.builder();
            this.hashBuilder = new HashCodeBuilder(identifier.hashCode());
            this.wildcard = identifier.isWildcarded();
            this.basePath = identifier.pathArguments;
        }

        Builder(PathArgument item, boolean wildcard) {
            this.pathBuilder = ImmutableList.builder();
            this.hashBuilder = new HashCodeBuilder();
            this.basePath = null;
            this.hashBuilder.addArgument((Object)item);
            this.pathBuilder.add((Object)item);
            this.wildcard = wildcard;
        }

        final boolean wildcard() {
            return this.wildcard;
        }

        public final <N extends DataObject & Augmentation<? super T>> Builder<N> augmentation(Class<N> container) {
            return this.append(Item.of(container), false);
        }

        public final <N extends ChildOf<? super T>> Builder<N> child(Class<N> container) {
            return this.append(Item.of(container), KeyAware.class.isAssignableFrom(container));
        }

        public final <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> Builder<N> child(Class<C> caze, Class<N> container) {
            return this.append(Item.of(caze, container), KeyAware.class.isAssignableFrom(container));
        }

        public final <N extends KeyAware<K> & ChildOf<? super T>, K extends Key<N>> KeyedBuilder<N, K> child(Class<@NonNull N> listItem, K listKey) {
            return this.append(IdentifiableItem.of(listItem, listKey));
        }

        public final <C extends ChoiceIn<? super T> & DataObject, K extends Key<N>, N extends KeyAware<K> & ChildOf<? super C>> KeyedBuilder<N, K> child(Class<C> caze, Class<N> listItem, K listKey) {
            return this.append(IdentifiableItem.of(caze, listItem, listKey));
        }

        public abstract @NonNull InstanceIdentifier<T> build();

        public final int hashCode() {
            return this.hashBuilder.build();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof Builder)) return false;
            Builder other = (Builder)obj;
            if (this.wildcard != other.wildcard) return false;
            if (this.hashCode() != other.hashCode()) return false;
            if (!Iterables.elementsEqual(this.pathArguments(), other.pathArguments())) return false;
            return true;
        }

        final Iterable<PathArgument> pathArguments() {
            ImmutableList args = this.pathBuilder.build();
            return this.basePath == null ? args : Iterables.concat(this.basePath, (Iterable)args);
        }

        final void appendItem(PathArgument item, boolean isWildcard) {
            this.hashBuilder.addArgument((Object)item);
            this.pathBuilder.add((Object)item);
            this.wildcard |= isWildcard;
        }

        abstract <X extends DataObject> @NonNull RegularBuilder<X> append(Item<X> var1, boolean var2);

        abstract <X extends DataObject & KeyAware<Y>, Y extends Key<X>> @NonNull KeyedBuilder<X, Y> append(IdentifiableItem<X, Y> var1);
    }

    private static final class CaseIdentifiableItem<C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C> & KeyAware<K>, K extends Key<T>>
    extends IdentifiableItem<T, K> {
        private static final long serialVersionUID = 1L;
        private final Class<C> caseType;

        CaseIdentifiableItem(Class<C> caseType, Class<T> type, K key) {
            super(type, key);
            this.caseType = Objects.requireNonNull(caseType);
        }

        public Optional<Class<C>> getCaseType() {
            return Optional.of(this.caseType);
        }
    }

    private static final class CaseItem<C extends ChoiceIn<?> & DataObject, T extends ChildOf<? super C>>
    extends Item<T> {
        private static final long serialVersionUID = 1L;
        private final Class<C> caseType;

        CaseItem(Class<C> caseType, Class<T> type) {
            super(type);
            this.caseType = Objects.requireNonNull(caseType);
        }

        public Optional<Class<C>> getCaseType() {
            return Optional.of(this.caseType);
        }
    }
}

