/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

class InstanceIdentifierV3<T extends DataObject>
implements Externalizable {
    private static final long serialVersionUID = 3L;
    private @Nullable Iterable<InstanceIdentifier.PathArgument> pathArguments;
    private @Nullable Class<T> targetType;
    private boolean wildcarded;
    private int hash;

    public InstanceIdentifierV3() {
    }

    InstanceIdentifierV3(InstanceIdentifier<T> source) {
        this.pathArguments = source.pathArguments;
        this.targetType = source.getTargetType();
        this.wildcarded = source.isWildcarded();
        this.hash = source.hashCode();
    }

    final int getHash() {
        return this.hash;
    }

    final Iterable<InstanceIdentifier.PathArgument> getPathArguments() {
        return this.pathArguments;
    }

    final Class<T> getTargetType() {
        return this.targetType;
    }

    final boolean isWildcarded() {
        return this.wildcarded;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.targetType);
        out.writeBoolean(this.wildcarded);
        out.writeInt(this.hash);
        out.writeInt(Iterables.size(this.pathArguments));
        for (InstanceIdentifier.PathArgument o : this.pathArguments) {
            out.writeObject(o);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.targetType = (Class)in.readObject();
        this.wildcarded = in.readBoolean();
        this.hash = in.readInt();
        int size = in.readInt();
        ArrayList<InstanceIdentifier.PathArgument> args = new ArrayList<InstanceIdentifier.PathArgument>();
        for (int i = 0; i < size; ++i) {
            args.add((InstanceIdentifier.PathArgument)in.readObject());
        }
        this.pathArguments = ImmutableList.copyOf(args);
    }

    Object readResolve() throws ObjectStreamException {
        return new InstanceIdentifier<T>(this.targetType, this.pathArguments, this.wildcarded, this.hash);
    }
}

