/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifierV3;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

final class KeyedInstanceIdentifierV2<T extends KeyAware<K> & DataObject, K extends Key<T>>
extends InstanceIdentifierV3<T> {
    private static final long serialVersionUID = 2L;
    private @Nullable K key;

    public KeyedInstanceIdentifierV2() {
    }

    KeyedInstanceIdentifierV2(KeyedInstanceIdentifier<T, K> source) {
        super(source);
        this.key = source.getKey();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.key);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = (Key)in.readObject();
    }

    @Override
    Object readResolve() throws ObjectStreamException {
        return new KeyedInstanceIdentifier(this.getTargetType(), this.getPathArguments(), this.isWildcarded(), this.getHash(), this.key);
    }
}

