/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.openconfig.model.api;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;

@NonNullByDefault
public final class OpenConfigConstants {
    private static final UnresolvedQName.Unqualified MODULE_NAME = UnresolvedQName.Unqualified.of((String)"openconfig-extensions").intern();
    static final XMLNamespace MODULE_NAMESPACE = XMLNamespace.of((String)"http://openconfig.net/yang/openconfig-ext").intern();
    private static final Revision SEMVER_REVISION = Revision.of((String)"2015-10-09");
    private static final Revision ENCRYPTED_VALUE_REVISION = Revision.of((String)"2017-01-29");
    private static final Revision HASHED_VALUE_REVISION = Revision.of((String)"2017-04-11");
    private static final Revision REGEXP_POSIX_REVISION = Revision.of((String)"2020-06-16");
    public static final QNameModule REGEXP_POSIX_MODULE = QNameModule.create((XMLNamespace)MODULE_NAMESPACE, (Revision)REGEXP_POSIX_REVISION).intern();
    public static final QNameModule SEMVER_MODULE = QNameModule.create((XMLNamespace)MODULE_NAMESPACE, (Revision)SEMVER_REVISION).intern();
    public static final QNameModule ENCRYPTED_VALUE_MODULE = QNameModule.create((XMLNamespace)MODULE_NAMESPACE, (Revision)ENCRYPTED_VALUE_REVISION).intern();
    public static final QNameModule HASHED_VALUE_MODULE = QNameModule.create((XMLNamespace)MODULE_NAMESPACE, (Revision)HASHED_VALUE_REVISION).intern();
    public static final SourceIdentifier SEMVER_SOURCE = new SourceIdentifier(MODULE_NAME, SEMVER_REVISION);
    public static final SourceIdentifier ENCRYPTED_VALUE_SOURCE = new SourceIdentifier(MODULE_NAME, ENCRYPTED_VALUE_REVISION);
    public static final SourceIdentifier HASHED_VALUE_SOURCE = new SourceIdentifier(MODULE_NAME, HASHED_VALUE_REVISION);
    public static final SourceIdentifier REGEXP_POSIX_SOURCE = new SourceIdentifier(MODULE_NAME, REGEXP_POSIX_REVISION);
    public static final String MODULE_PREFIX = "oc-ext";

    private OpenConfigConstants() {
    }

    public static Collection<SourceIdentifier> knownModelSources() {
        return ImmutableList.of((Object)HASHED_VALUE_SOURCE, (Object)ENCRYPTED_VALUE_SOURCE, (Object)SEMVER_SOURCE);
    }
}

