/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractIndexedEffectiveStatement;

@Beta
public abstract class AbstractDeclaredEffectiveStatement<A, D extends DeclaredStatement<A>>
extends AbstractIndexedEffectiveStatement<A, D> {
    public abstract @NonNull D getDeclared();

    public static abstract class DefaultWithDataTree<A, D extends DeclaredStatement<A>>
    extends WithDataTree<A, D> {
        private final @NonNull Map<QName, SchemaTreeEffectiveStatement<?>> schemaTree;
        private final @NonNull Map<QName, DataTreeEffectiveStatement<?>> dataTree;
        private final @NonNull Object substatements;
        private final @NonNull D declared;

        protected DefaultWithDataTree(D declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
            this.declared = (DeclaredStatement)Objects.requireNonNull(declared);
            this.substatements = DefaultWithDataTree.maskList(substatements);
            Map<QName, SchemaTreeEffectiveStatement<?>> schema = DefaultWithDataTree.createSchemaTreeNamespace(substatements);
            this.schemaTree = DefaultWithDataTree.immutableNamespaceOf(schema);
            this.dataTree = DefaultWithDataTree.createDataTreeNamespace(schema.values(), this.schemaTree);
        }

        protected DefaultWithDataTree(DefaultWithDataTree<A, D> original) {
            this.declared = original.declared;
            this.schemaTree = original.schemaTree;
            this.dataTree = original.dataTree;
            this.substatements = original.substatements;
        }

        @Override
        public final @NonNull D getDeclared() {
            return this.declared;
        }

        @Override
        public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
            return DefaultWithDataTree.unmaskList((Object)this.substatements);
        }

        public final Collection<SchemaTreeEffectiveStatement<?>> schemaTreeNodes() {
            return this.schemaTree.values();
        }

        public final Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(QName qname) {
            return DefaultWithDataTree.findValue(this.schemaTree, (Object)qname);
        }

        public final Collection<DataTreeEffectiveStatement<?>> dataTreeNodes() {
            return this.dataTree.values();
        }

        public final Optional<DataTreeEffectiveStatement<?>> findDataTreeNode(QName qname) {
            return DefaultWithDataTree.findValue(this.dataTree, (Object)qname);
        }

        public static abstract class WithTypedefNamespace<A, D extends DeclaredStatement<A>>
        extends DefaultWithDataTree<A, D>
        implements TypedefAwareEffectiveStatement<A, D> {
            protected WithTypedefNamespace(D declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
                super(declared, substatements);
                WithTypedefNamespace.createTypedefNamespace(substatements);
            }

            protected WithTypedefNamespace(WithTypedefNamespace<A, D> original) {
                super(original);
            }
        }
    }

    public static abstract class DefaultWithSchemaTree<A, D extends DeclaredStatement<A>>
    extends WithSchemaTree<A, D> {
        private final @NonNull Map<QName, SchemaTreeEffectiveStatement<?>> schemaTree;
        private final @NonNull Object substatements;
        private final @NonNull D declared;

        protected DefaultWithSchemaTree(D declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
            this.declared = (DeclaredStatement)Objects.requireNonNull(declared);
            this.substatements = DefaultWithSchemaTree.maskList(substatements);
            this.schemaTree = DefaultWithSchemaTree.immutableNamespaceOf(DefaultWithSchemaTree.createSchemaTreeNamespace(substatements));
        }

        protected DefaultWithSchemaTree(DefaultWithSchemaTree<A, D> original) {
            this.declared = original.declared;
            this.schemaTree = original.schemaTree;
            this.substatements = original.substatements;
        }

        @Override
        public final @NonNull D getDeclared() {
            return this.declared;
        }

        @Override
        public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
            return DefaultWithSchemaTree.unmaskList((Object)this.substatements);
        }

        public final Collection<SchemaTreeEffectiveStatement<?>> schemaTreeNodes() {
            return this.schemaTree.values();
        }

        public final Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(QName qname) {
            return DefaultWithSchemaTree.findValue(this.schemaTree, (Object)Objects.requireNonNull(qname));
        }
    }

    public static abstract class DefaultWithArgument<A, D extends DeclaredStatement<A>>
    extends Default<A, D> {
        private final A argument;

        protected DefaultWithArgument(D declared, A argument) {
            super(declared);
            this.argument = argument;
        }

        public final A argument() {
            return this.argument;
        }

        public static abstract class WithSubstatements<A, D extends DeclaredStatement<A>>
        extends DefaultWithArgument<A, D> {
            private final @NonNull Object substatements;

            protected WithSubstatements(D declared, A argument, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
                super(declared, argument);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            @Override
            public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
                return WithSubstatements.unmaskList((Object)this.substatements);
            }
        }
    }

    public static abstract class DefaultArgument<A, D extends DeclaredStatement<A>>
    extends Default<A, D> {
        protected DefaultArgument(D declared) {
            super(declared);
        }

        protected DefaultArgument(DefaultArgument<A, D> original) {
            super(original);
        }

        public final A argument() {
            return (A)this.getDeclared().argument();
        }

        public static abstract class WithSubstatements<A, D extends DeclaredStatement<A>>
        extends DefaultArgument<A, D> {
            private final @NonNull Object substatements;

            protected WithSubstatements(D declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
                super(declared);
                this.substatements = WithSubstatements.maskList(substatements);
            }

            protected WithSubstatements(WithSubstatements<A, D> original) {
                super(original);
                this.substatements = original.substatements;
            }

            @Override
            public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
                return WithSubstatements.unmaskList((Object)this.substatements);
            }
        }
    }

    public static abstract class Default<A, D extends DeclaredStatement<A>>
    extends AbstractDeclaredEffectiveStatement<A, D> {
        private final @NonNull D declared;

        protected Default(D declared) {
            this.declared = (DeclaredStatement)Objects.requireNonNull(declared);
        }

        protected Default(Default<A, D> original) {
            this.declared = original.declared;
        }

        @Override
        public final @NonNull D getDeclared() {
            return this.declared;
        }
    }

    public static abstract class WithDataTree<A, D extends DeclaredStatement<A>>
    extends WithSchemaTree<A, D>
    implements DataTreeAwareEffectiveStatement<A, D> {
    }

    public static abstract class WithSchemaTree<A, D extends DeclaredStatement<A>>
    extends AbstractDeclaredEffectiveStatement<A, D>
    implements SchemaTreeAwareEffectiveStatement<A, D> {
        protected final @Nullable DataSchemaNode dataSchemaNode(QName name) {
            Verify.verify((boolean)(this instanceof DataNodeContainer));
            return WithSchemaTree.filterOptional((Optional)this.findSchemaTreeNode(name), DataSchemaNode.class).orElse(null);
        }
    }
}

