/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContactEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrganizationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.compat.NotificationNodeContainerCompat;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public abstract class AbstractEffectiveModule<D extends DeclaredStatement<UnresolvedQName.Unqualified>, E extends DataTreeAwareEffectiveStatement<UnresolvedQName.Unqualified, D>>
extends AbstractDeclaredEffectiveStatement.DefaultWithDataTree.WithTypedefNamespace<UnresolvedQName.Unqualified, D>
implements ModuleLike,
EffectiveStatementMixins.DocumentedNodeMixin<UnresolvedQName.Unqualified, D>,
NotificationNodeContainerCompat<UnresolvedQName.Unqualified, D, E> {
    private final String prefix;
    private final ImmutableSet<GroupingDefinition> groupings;
    private final ImmutableSet<UsesNode> uses;
    private final ImmutableSet<TypeDefinition<?>> typeDefinitions;

    protected AbstractEffectiveModule(EffectiveStmtCtx.Current<UnresolvedQName.Unqualified, D> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, String prefix) {
        super(stmt.declared(), substatements);
        this.prefix = Objects.requireNonNull(prefix);
        LinkedHashSet<GroupingDefinition> mutableGroupings = new LinkedHashSet<GroupingDefinition>();
        LinkedHashSet<UsesNode> mutableUses = new LinkedHashSet<UsesNode>();
        LinkedHashSet<TypeDefinition> mutableTypeDefinitions = new LinkedHashSet<TypeDefinition>();
        for (EffectiveStatement effectiveStatement : this.effectiveSubstatements()) {
            GroupingDefinition grouping;
            TypedefEffectiveStatement typedef;
            UsesNode usesNode;
            if (effectiveStatement instanceof UsesNode && !mutableUses.add(usesNode = (UsesNode)effectiveStatement)) {
                throw EffectiveStmtUtils.createNameCollisionSourceException(stmt, effectiveStatement);
            }
            if (effectiveStatement instanceof TypedefEffectiveStatement && !mutableTypeDefinitions.add((typedef = (TypedefEffectiveStatement)effectiveStatement).getTypeDefinition())) {
                throw EffectiveStmtUtils.createNameCollisionSourceException(stmt, effectiveStatement);
            }
            if (!(effectiveStatement instanceof GroupingDefinition) || mutableGroupings.add(grouping = (GroupingDefinition)effectiveStatement)) continue;
            throw EffectiveStmtUtils.createNameCollisionSourceException(stmt, effectiveStatement);
        }
        this.groupings = ImmutableSet.copyOf(mutableGroupings);
        this.typeDefinitions = ImmutableSet.copyOf(mutableTypeDefinitions);
        this.uses = ImmutableSet.copyOf(mutableUses);
    }

    public UnresolvedQName.Unqualified argument() {
        return (UnresolvedQName.Unqualified)this.getDeclared().argument();
    }

    public String getName() {
        return this.argument().getLocalName();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public YangVersion getYangVersion() {
        return this.findFirstEffectiveSubstatementArgument(YangVersionEffectiveStatement.class).orElse(YangVersion.VERSION_1);
    }

    public Optional<String> getOrganization() {
        return this.findFirstEffectiveSubstatementArgument(OrganizationEffectiveStatement.class);
    }

    public Optional<String> getContact() {
        return this.findFirstEffectiveSubstatementArgument(ContactEffectiveStatement.class);
    }

    public Collection<? extends @NonNull ModuleImport> getImports() {
        return this.filterSubstatements(ModuleImport.class);
    }

    public Collection<? extends @NonNull FeatureDefinition> getFeatures() {
        return this.filterSubstatements(FeatureDefinition.class);
    }

    public Collection<? extends @NonNull NotificationDefinition> getNotifications() {
        return this.filterSubstatements(NotificationDefinition.class);
    }

    public Collection<? extends @NonNull AugmentationSchemaNode> getAugmentations() {
        return this.filterSubstatements(AugmentationSchemaNode.class);
    }

    public Collection<? extends @NonNull RpcDefinition> getRpcs() {
        return this.filterSubstatements(RpcDefinition.class);
    }

    public Collection<? extends @NonNull Deviation> getDeviations() {
        return this.filterSubstatements(Deviation.class);
    }

    public Collection<? extends @NonNull ExtensionDefinition> getExtensionSchemaNodes() {
        return this.filterSubstatements(ExtensionDefinition.class);
    }

    public Collection<? extends @NonNull IdentitySchemaNode> getIdentities() {
        return this.filterSubstatements(IdentitySchemaNode.class);
    }

    public final Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public final Collection<? extends DataSchemaNode> getChildNodes() {
        return this.filterSubstatements(DataSchemaNode.class);
    }

    public final Collection<? extends GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    public final DataSchemaNode dataChildByName(QName name) {
        return this.dataSchemaNode(name);
    }

    public Collection<? extends UsesNode> getUses() {
        return this.uses;
    }

    protected static final @NonNull String findPrefix(CommonStmtCtx stmt, Collection<? extends EffectiveStatement<?, ?>> substatements, String type, String name) {
        return substatements.stream().filter(PrefixEffectiveStatement.class::isInstance).map(prefix -> (String)((PrefixEffectiveStatement)prefix).argument()).findAny().orElseThrow(() -> new SourceException(stmt, "Unable to resolve prefix for %s %s.", new Object[]{type, name}));
    }

    protected final void appendPrefixes(EffectiveStmtCtx.Current<?, ?> stmt, ImmutableMap.Builder<String, ModuleEffectiveStatement> builder) {
        this.streamEffectiveSubstatements(ImportEffectiveStatement.class).map(imp -> (String)imp.prefix().argument()).forEach(pfx -> {
            StmtContext importedCtx = (StmtContext)Verify.verifyNotNull((Object)((StmtContext)stmt.namespaceItem(ParserNamespaces.IMPORT_PREFIX_TO_MODULECTX, pfx)), (String)"Failed to resolve prefix %s", (Object[])new Object[]{pfx});
            builder.put(pfx, (Object)((ModuleEffectiveStatement)importedCtx.buildEffective()));
        });
    }

    private <T> @NonNull Collection<? extends T> filterSubstatements(Class<T> type) {
        return Collections2.filter((Collection)this.effectiveSubstatements(), type::isInstance);
    }
}

