/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment;

import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.AugmentImplicitHandlingNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.AugmentInferenceAction;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

abstract class AbstractAugmentStatementSupport
extends AbstractStatementSupport<SchemaNodeIdentifier, AugmentStatement, AugmentEffectiveStatement> {
    private static final Pattern PATH_REL_PATTERN1 = Pattern.compile("\\.\\.?\\s*/(.+)");
    private static final Pattern PATH_REL_PATTERN2 = Pattern.compile("//.*");

    AbstractAugmentStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.AUGMENT, StatementSupport.StatementPolicy.copyDeclared((copy, current, substatements) -> ((SchemaNodeIdentifier)copy.getArgument()).equals(current.getArgument()) && copy.moduleName().getModule().equals((Object)current.moduleName().getModule())), config, validator);
    }

    public final SchemaNodeIdentifier parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        SourceException.throwIf((PATH_REL_PATTERN1.matcher(value).matches() || PATH_REL_PATTERN2.matcher(value).matches() ? 1 : 0) != 0, ctx, (String)"Augment argument '%s' is not valid, it can be only absolute path; or descendant if used in uses", (Object[])new Object[]{value});
        SchemaNodeIdentifier result = ArgumentUtils.nodeIdentifierFromPath(ctx, value);
        StatementDefinition parent = ctx.coerceParentContext().publicDefinition();
        if (parent == YangStmtMapping.USES) {
            SourceException.throwIf((boolean)(result instanceof SchemaNodeIdentifier.Absolute), ctx, (String)"Absolute schema node identifier is not allowed when used within a uses statement", (Object[])new Object[0]);
        } else {
            SourceException.throwIf((boolean)(result instanceof SchemaNodeIdentifier.Descendant), ctx, (String)"Descendant schema node identifier is not allowed when used outside of a uses statement", (Object[])new Object[0]);
        }
        return result;
    }

    public final void onFullDefinitionDeclared(StmtContext.Mutable<SchemaNodeIdentifier, AugmentStatement, AugmentEffectiveStatement> augmentNode) {
        if (!augmentNode.isSupportedByFeatures()) {
            augmentNode.setUnsupported();
        }
        super.onFullDefinitionDeclared(augmentNode);
        if (StmtContextUtils.isInExtensionBody(augmentNode)) {
            return;
        }
        ModelActionBuilder augmentAction = augmentNode.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        augmentAction.requiresCtx(augmentNode, ModelProcessingPhase.EFFECTIVE_MODEL);
        ModelActionBuilder.Prerequisite target = augmentAction.mutatesEffectiveCtxPath(AbstractAugmentStatementSupport.getSearchRoot(augmentNode), ParserNamespaces.schemaTree(), (Iterable)((SchemaNodeIdentifier)augmentNode.getArgument()).getNodeIdentifiers());
        augmentAction.apply((ModelActionBuilder.InferenceAction)new AugmentInferenceAction(this, augmentNode, target));
    }

    protected final AugmentStatement createDeclared(BoundStmtCtx<SchemaNodeIdentifier> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createAugment((String)ctx.getRawArgument(), (SchemaNodeIdentifier)((SchemaNodeIdentifier)ctx.getArgument()), substatements);
    }

    protected final AugmentStatement attachDeclarationReference(AugmentStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateAugment((AugmentStatement)stmt, (DeclarationReference)reference);
    }

    protected final Stream<? extends StmtContext<?, ?, ?>> statementsToBuild(EffectiveStmtCtx.Current<SchemaNodeIdentifier, AugmentStatement> stmt, Stream<? extends StmtContext<?, ?, ?>> substatements) {
        StmtContext.Mutable implicitDef = (StmtContext.Mutable)stmt.namespaceItem(AugmentImplicitHandlingNamespace.INSTANCE, (Object)Empty.value());
        return implicitDef == null ? substatements : substatements.map(subCtx -> implicitDef.wrapWithImplicit(subCtx));
    }

    protected final AugmentEffectiveStatement createEffective(EffectiveStmtCtx.Current<SchemaNodeIdentifier, AugmentStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        int flags = new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus((Status)AbstractAugmentStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).toFlags();
        try {
            return EffectiveStatements.createAugment((AugmentStatement)((AugmentStatement)stmt.declared()), (SchemaNodeIdentifier)((SchemaNodeIdentifier)stmt.getArgument()), (int)flags, (QNameModule)stmt.moduleName().getModule(), substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    abstract boolean allowsMandatory(StmtContext<?, ?, ?> var1);

    static StmtContext<?, ?, ?> getSearchRoot(StmtContext<?, ?, ?> augmentContext) {
        StmtContext parent = augmentContext.coerceParentContext();
        if (YangStmtMapping.USES == parent.publicDefinition()) {
            return parent.getParentContext();
        }
        return parent;
    }

    static boolean hasWhenSubstatement(StmtContext<?, ?, ?> ctx) {
        return ctx.hasSubstatement(WhenEffectiveStatement.class);
    }
}

