/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractInternedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class ValueStatementSupport
extends AbstractInternedStatementSupport<Integer, ValueStatement, ValueEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.VALUE).build();

    public ValueStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.VALUE, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public Integer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException(ctx, (Throwable)e, "%s is not valid value statement integer argument in a range of -2147483648..2147483647", new Object[]{value});
        }
    }

    protected ValueStatement createDeclared(Integer argument, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createValue((Integer)argument, substatements);
    }

    protected ValueStatement attachDeclarationReference(ValueStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateValue((ValueStatement)stmt, (DeclarationReference)reference);
    }

    protected ValueStatement createEmptyDeclared(@NonNull Integer argument) {
        return DeclaredStatements.createValue((Integer)argument);
    }

    protected ValueEffectiveStatement createEffective(ValueStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createValue((ValueStatement)declared, substatements);
    }

    protected ValueEffectiveStatement createEmptyEffective(@NonNull ValueStatement declared) {
        return EffectiveStatements.createValue((ValueStatement)declared);
    }
}

