/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import java.util.Objects;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.YangNamespaceContextNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParser;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public final class XPathSupport {
    private static final Logger LOG = LoggerFactory.getLogger(XPathSupport.class);
    private final YangXPathParserFactory factory;

    public XPathSupport(YangXPathParserFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    YangXPathExpression.QualifiedBound parseXPath(StmtContext<?, ?, ?> ctx, String xpath) {
        YangXPathExpression.QualifiedBound parsed;
        YangXPathParser.QualifiedBound parser = this.factory.newParser(YangNamespaceContextNamespace.computeIfAbsent(ctx));
        try {
            parsed = parser.parseExpression(xpath);
        }
        catch (XPathExpressionException e) {
            throw new SourceException(ctx, (Throwable)e, "Argument \"%s\" is not valid XPath string", new Object[]{xpath});
        }
        if (ctx.yangVersion().compareTo((Enum)parsed.getYangVersion()) < 0) {
            LOG.warn("{} features required in {} context to parse expression '{}' [at {}]", new Object[]{parsed.getYangVersion().getReference(), ctx.yangVersion().getReference(), xpath, ctx.sourceReference()});
        }
        return parsed;
    }
}

