/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern;

import com.google.common.collect.ImmutableSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RegexUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RegexUtils.class);
    private static final Pattern BETWEEN_CURLY_BRACES_PATTERN = Pattern.compile("\\{(.+?)\\}");
    private static final ImmutableSet<String> JAVA_UNICODE_BLOCKS = ImmutableSet.builder().add((Object)"AegeanNumbers").add((Object)"AlchemicalSymbols").add((Object)"AlphabeticPresentationForms").add((Object)"AncientGreekMusicalNotation").add((Object)"AncientGreekNumbers").add((Object)"AncientSymbols").add((Object)"Arabic").add((Object)"ArabicPresentationForms-A").add((Object)"ArabicPresentationForms-B").add((Object)"ArabicSupplement").add((Object)"Armenian").add((Object)"Arrows").add((Object)"Avestan").add((Object)"Balinese").add((Object)"Bamum").add((Object)"BamumSupplement").add((Object)"BasicLatin").add((Object)"Batak").add((Object)"Bengali").add((Object)"BlockElements").add((Object)"Bopomofo").add((Object)"BopomofoExtended").add((Object)"BoxDrawing").add((Object)"Brahmi").add((Object)"BraillePatterns").add((Object)"Buginese").add((Object)"Buhid").add((Object)"ByzantineMusicalSymbols").add((Object)"Carian").add((Object)"Cham").add((Object)"Cherokee").add((Object)"CJKCompatibility").add((Object)"CJKCompatibilityForms").add((Object)"CJKCompatibilityIdeographs").add((Object)"CJKCompatibilityIdeographsSupplement").add((Object)"CJKRadicalsSupplement").add((Object)"CJKStrokes").add((Object)"CJKSymbolsandPunctuation").add((Object)"CJKUnifiedIdeographs").add((Object)"CJKUnifiedIdeographsExtensionA").add((Object)"CJKUnifiedIdeographsExtensionB").add((Object)"CJKUnifiedIdeographsExtensionC").add((Object)"CJKUnifiedIdeographsExtensionD").add((Object)"CombiningDiacriticalMarks").add((Object)"CombiningDiacriticalMarksSupplement").add((Object)"CombiningHalfMarks").add((Object)"CombiningDiacriticalMarksforSymbols").add((Object)"CommonIndicNumberForms").add((Object)"ControlPictures").add((Object)"Coptic").add((Object)"CountingRodNumerals").add((Object)"Cuneiform").add((Object)"CuneiformNumbersandPunctuation").add((Object)"CurrencySymbols").add((Object)"CypriotSyllabary").add((Object)"Cyrillic").add((Object)"CyrillicExtended-A").add((Object)"CyrillicExtended-B").add((Object)"CyrillicSupplementary").add((Object)"Deseret").add((Object)"Devanagari").add((Object)"DevanagariExtended").add((Object)"Dingbats").add((Object)"DominoTiles").add((Object)"EgyptianHieroglyphs").add((Object)"Emoticons").add((Object)"EnclosedAlphanumericSupplement").add((Object)"EnclosedAlphanumerics").add((Object)"EnclosedCJKLettersandMonths").add((Object)"EnclosedIdeographicSupplement").add((Object)"Ethiopic").add((Object)"EthiopicExtended").add((Object)"EthiopicExtended-A").add((Object)"EthiopicSupplement").add((Object)"GeneralPunctuation").add((Object)"GeometricShapes").add((Object)"Georgian").add((Object)"GeorgianSupplement").add((Object)"Glagolitic").add((Object)"Gothic").add((Object)"GreekandCoptic").add((Object)"GreekExtended").add((Object)"Gujarati").add((Object)"Gurmukhi").add((Object)"HalfwidthandFullwidthForms").add((Object)"HangulCompatibilityJamo").add((Object)"HangulJamo").add((Object)"HangulJamoExtended-A").add((Object)"HangulJamoExtended-B").add((Object)"HangulSyllables").add((Object)"Hanunoo").add((Object)"Hebrew").add((Object)"HighPrivateUseSurrogates").add((Object)"HighSurrogates").add((Object)"Hiragana").add((Object)"IdeographicDescriptionCharacters").add((Object)"ImperialAramaic").add((Object)"InscriptionalPahlavi").add((Object)"InscriptionalParthian").add((Object)"IPAExtensions").add((Object)"Javanese").add((Object)"Kaithi").add((Object)"KanaSupplement").add((Object)"Kanbun").add((Object)"Kangxi Radicals").add((Object)"Kannada").add((Object)"Katakana").add((Object)"KatakanaPhoneticExtensions").add((Object)"KayahLi").add((Object)"Kharoshthi").add((Object)"Khmer").add((Object)"KhmerSymbols").add((Object)"Lao").add((Object)"Latin-1Supplement").add((Object)"LatinExtended-A").add((Object)"LatinExtendedAdditional").add((Object)"LatinExtended-B").add((Object)"LatinExtended-C").add((Object)"LatinExtended-D").add((Object)"Lepcha").add((Object)"LetterlikeSymbols").add((Object)"Limbu").add((Object)"LinearBIdeograms").add((Object)"LinearBSyllabary").add((Object)"Lisu").add((Object)"LowSurrogates").add((Object)"Lycian").add((Object)"Lydian").add((Object)"MahjongTiles").add((Object)"Malayalam").add((Object)"Mandaic").add((Object)"MathematicalAlphanumericSymbols").add((Object)"MathematicalOperators").add((Object)"MeeteiMayek").add((Object)"MiscellaneousMathematicalSymbols-A").add((Object)"MiscellaneousMathematicalSymbols-B").add((Object)"MiscellaneousSymbols").add((Object)"MiscellaneousSymbolsandArrows").add((Object)"MiscellaneousSymbolsAndPictographs").add((Object)"MiscellaneousTechnical").add((Object)"ModifierToneLetters").add((Object)"Mongolian").add((Object)"MusicalSymbols").add((Object)"Myanmar").add((Object)"MyanmarExtended-A").add((Object)"NewTaiLue").add((Object)"NKo").add((Object)"NumberForms").add((Object)"Ogham").add((Object)"OlChiki").add((Object)"OldItalic").add((Object)"OldPersian").add((Object)"OldSouthArabian").add((Object)"OldTurkic").add((Object)"OpticalCharacterRecognition").add((Object)"Oriya").add((Object)"Osmanya").add((Object)"Phags-pa").add((Object)"PhaistosDisc").add((Object)"Phoenician").add((Object)"PhoneticExtensions").add((Object)"PhoneticExtensionsSupplement").add((Object)"PlayingCards").add((Object)"PrivateUseArea").add((Object)"Rejang").add((Object)"RumiNumeralSymbols").add((Object)"Runic").add((Object)"Samaritan").add((Object)"Saurashtra").add((Object)"Shavian").add((Object)"Sinhala").add((Object)"SmallFormVariants").add((Object)"SpacingModifierLetters").add((Object)"Specials").add((Object)"Sundanese").add((Object)"SuperscriptsandSubscripts").add((Object)"SupplementalArrows-A").add((Object)"SupplementalArrows-B").add((Object)"SupplementalMathematicalOperators").add((Object)"SupplementalPunctuation").add((Object)"SupplementaryPrivateUseArea-A").add((Object)"SupplementaryPrivateUseArea-B").add((Object)"SylotiNagri").add((Object)"Syriac").add((Object)"Tagalog").add((Object)"Tagbanwa").add((Object)"Tags").add((Object)"TaiLe").add((Object)"TaiTham").add((Object)"TaiViet").add((Object)"TaiXuanJingSymbols").add((Object)"Tamil").add((Object)"Telugu").add((Object)"Thaana").add((Object)"Thai").add((Object)"Tibetan").add((Object)"Tifinagh").add((Object)"TransportAndMapSymbols").add((Object)"Ugaritic").add((Object)"UnifiedCanadianAboriginalSyllabics").add((Object)"UnifiedCanadianAboriginalSyllabicsExtended").add((Object)"Vai").add((Object)"VariationSelectors").add((Object)"VariationSelectorsSupplement").add((Object)"VedicExtensions").add((Object)"VerticalForms").add((Object)"YiRadicals").add((Object)"YiSyllables").add((Object)"YijingHexagramSymbols").add((Object)"ArabicExtended-A").add((Object)"ArabicMathematicalAlphabeticSymbols").add((Object)"Chakma").add((Object)"MeeteiMeyekExtensions").add((Object)"MeroiticCursive").add((Object)"MeroiticHieroglyphs").add((Object)"Miao").add((Object)"Sharada").add((Object)"SoraSompeng").add((Object)"SundaneseSupplement").add((Object)"Takri").add((Object)"Ahom").add((Object)"AnatolianHieroglyphs").add((Object)"BassaVah").add((Object)"CaucasianAlbanian").add((Object)"CherokeeSupplement").add((Object)"CJKUnifiedIdeographsExtensionE").add((Object)"CombiningDiacriticalMarksExtended").add((Object)"CopticEpactNumbers").add((Object)"Duployan").add((Object)"EarlyDynasticCuneiform").add((Object)"Elbasan").add((Object)"GeometricShapesExtended").add((Object)"Grantha").add((Object)"Hatran").add((Object)"Khojki").add((Object)"Khudawadi").add((Object)"LatinExtended-E").add((Object)"LinearA").add((Object)"Mahajani").add((Object)"Manichaean").add((Object)"MendeKikakui").add((Object)"Modi").add((Object)"Mro").add((Object)"Multani").add((Object)"MyanmarExtended-B").add((Object)"Nabataean").add((Object)"OldHungarian").add((Object)"OldNorthArabian").add((Object)"OldPermic").add((Object)"OrnamentalDingbats").add((Object)"PahawhHmong").add((Object)"Palmyrene").add((Object)"PauCinHau").add((Object)"PsalterPahlavi").add((Object)"ShorthandFormatControls").add((Object)"Siddham").add((Object)"SinhalaArchaicNumbers").add((Object)"SupplementalArrows-C").add((Object)"SupplementalSymbolsandPictographs").add((Object)"SuttonSignWriting").add((Object)"Tirhuta").add((Object)"WarangCiti").add((Object)"Adlam").add((Object)"Bhaiksuki").add((Object)"CJKUnifiedIdeographsExtensionF").add((Object)"CyrillicExtended-C").add((Object)"GlagoliticSupplement").add((Object)"IdeographicSymbolsandPunctuation").add((Object)"KanaExtended-A").add((Object)"Marchen").add((Object)"MasaramGondi").add((Object)"MongolianSupplement").add((Object)"Newa").add((Object)"Nushu").add((Object)"Osage").add((Object)"Soyombo").add((Object)"SyriacSupplement").add((Object)"Tangut").add((Object)"TangutComponents").add((Object)"ZanabazarSquare").add((Object)"ChessSymbols").add((Object)"Dogra").add((Object)"GeorgianExtended").add((Object)"GunjalaGondi").add((Object)"HanifiRohingya").add((Object)"IndicSiyaqNumbers").add((Object)"Makasar").add((Object)"MayanNumerals").add((Object)"Medefaidrin").add((Object)"OldSogdian").add((Object)"Sogdian").add((Object)"EgyptianHieroglyphFormatControls").add((Object)"Elymaic").add((Object)"Nandinagari").add((Object)"NyiakengPuachueHmong").add((Object)"OttomanSiyaqNumbers").add((Object)"SmallKanaExtension").add((Object)"SymbolsandPictographsExtended-A").add((Object)"TamilSupplement").add((Object)"Wancho").build();
    private static final int UNICODE_SCRIPT_FIX_COUNTER = 30;

    private RegexUtils() {
    }

    static String getJavaRegexFromXSD(String xsdRegex) {
        return "^(?:" + RegexUtils.fixUnicodeScriptPattern(RegexUtils.escapeChars(xsdRegex)) + ")$";
    }

    private static String escapeChars(String regex) {
        StringBuilder result = new StringBuilder(regex.length());
        int bracket = 0;
        boolean escape = false;
        block6: for (int i = 0; i < regex.length(); ++i) {
            char ch = regex.charAt(i);
            switch (ch) {
                case '[': {
                    if (!escape) {
                        ++bracket;
                    }
                    escape = false;
                    result.append(ch);
                    continue block6;
                }
                case ']': {
                    if (!escape) {
                        --bracket;
                    }
                    escape = false;
                    result.append(ch);
                    continue block6;
                }
                case '\\': {
                    escape = !escape;
                    result.append(ch);
                    continue block6;
                }
                case '$': 
                case '^': {
                    if (bracket == 0) {
                        result.append('\\');
                    }
                    escape = false;
                    result.append(ch);
                    continue block6;
                }
                default: {
                    escape = false;
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    private static String fixUnicodeScriptPattern(String rawPattern) {
        for (int i = 0; i < 30; ++i) {
            try {
                Pattern.compile(rawPattern);
                return rawPattern;
            }
            catch (PatternSyntaxException ex) {
                LOG.debug("Invalid regex pattern syntax in: {}", (Object)rawPattern, (Object)ex);
                String msg = ex.getMessage();
                if (!msg.startsWith("Unknown character script name") && !msg.startsWith("Unknown character property name")) {
                    return rawPattern;
                }
                rawPattern = RegexUtils.fixUnknownScripts(msg, rawPattern);
                continue;
            }
        }
        LOG.warn("Regex pattern could not be fixed: {}", (Object)rawPattern);
        return rawPattern;
    }

    private static String fixUnknownScripts(String exMessage, String rawPattern) {
        StringBuilder result = new StringBuilder(rawPattern);
        Matcher matcher = BETWEEN_CURLY_BRACES_PATTERN.matcher(exMessage);
        if (matcher.find()) {
            String capturedGroup = matcher.group(1);
            if (capturedGroup.startsWith("In/Is")) {
                capturedGroup = capturedGroup.substring(5);
            } else if (capturedGroup.startsWith("Is")) {
                capturedGroup = capturedGroup.substring(2);
            }
            if (JAVA_UNICODE_BLOCKS.contains((Object)capturedGroup)) {
                int idx = rawPattern.indexOf("Is" + capturedGroup);
                result = result.replace(idx, idx + 2, "In");
            }
        }
        return result.toString();
    }
}

