/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.YangValidationBundles;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.EmptyLocalUsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.FullCopiedUsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.RegularLocalUsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.SimpleCopiedUsesEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.uses.SourceGroupingNamespace;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UsesStatementSupport
extends AbstractQNameStatementSupport<UsesStatement, UsesEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(UsesStatementSupport.class);
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.USES).addAny((StatementDefinition)YangStmtMapping.AUGMENT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.REFINE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();

    public UsesStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.USES, StatementSupport.StatementPolicy.exactReplica(), config, SUBSTATEMENT_VALIDATOR);
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseNodeIdentifier(ctx, (String)value);
    }

    public void onFullDefinitionDeclared(final StmtContext.Mutable<QName, UsesStatement, UsesEffectiveStatement> usesNode) {
        super.onFullDefinitionDeclared(usesNode);
        ModelActionBuilder usesAction = usesNode.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        final QName groupingName = (QName)usesNode.argument();
        final ModelActionBuilder.Prerequisite sourceGroupingPre = usesAction.requiresCtx(usesNode, ParserNamespaces.GROUPING, (Object)groupingName, ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite targetNodePre = usesAction.mutatesEffectiveCtx(usesNode.getParentContext());
        usesAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext.Mutable targetNodeStmtCtx = (StmtContext.Mutable)targetNodePre.resolve(ctx);
                StmtContext sourceGrpStmtCtx = (StmtContext)sourceGroupingPre.resolve(ctx);
                UsesStatementSupport.copyFromSourceToTarget(sourceGrpStmtCtx, targetNodeStmtCtx, (StmtContext.Mutable<QName, UsesStatement, UsesEffectiveStatement>)usesNode);
                for (StmtContext.Mutable subStmt : usesNode.mutableDeclaredSubstatements()) {
                    if (!subStmt.producesDeclared(RefineStatement.class) || !subStmt.isSupportedToBuildEffective()) continue;
                    UsesStatementSupport.performRefine(subStmt, targetNodeStmtCtx);
                }
                StmtContextUtils.validateIfFeatureAndWhenOnListKeys((StmtContext)usesNode);
                usesNode.addToNs(SourceGroupingNamespace.INSTANCE, (Object)Empty.value(), (Object)sourceGrpStmtCtx);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                InferenceException.throwIf((boolean)failed.contains(sourceGroupingPre), (CommonStmtCtx)usesNode, (String)"Grouping '%s' was not resolved.", (Object[])new Object[]{groupingName});
                throw new InferenceException("Unknown error occurred.", (CommonStmtCtx)usesNode);
            }
        });
    }

    protected UsesStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createUses((String)ctx.getRawArgument(), (QName)((QName)ctx.getArgument()), substatements);
    }

    protected UsesStatement attachDeclarationReference(UsesStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateUses((UsesStatement)stmt, (DeclarationReference)reference);
    }

    protected UsesEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, UsesStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        EffectiveStatement source = ((StmtContext)Verify.verifyNotNull((Object)((StmtContext)stmt.namespaceItem(SourceGroupingNamespace.INSTANCE, (Object)Empty.value())))).buildEffective();
        Verify.verify((boolean)(source instanceof GroupingDefinition), (String)"Unexpected source %s", (Object)source);
        GroupingDefinition sourceGrouping = (GroupingDefinition)source;
        int flags = EffectiveStmtUtils.historyAndStatusFlags((CopyableNode)stmt.history(), substatements);
        QName argument = (QName)stmt.getArgument();
        UsesStatement declared = (UsesStatement)stmt.declared();
        if (substatements.isEmpty()) {
            return argument.equals(declared.argument()) ? new EmptyLocalUsesEffectiveStatement(declared, sourceGrouping, flags) : new SimpleCopiedUsesEffectiveStatement(declared, argument, sourceGrouping, flags);
        }
        if (((QName)declared.argument()).equals((Object)argument)) {
            return new RegularLocalUsesEffectiveStatement(declared, sourceGrouping, flags, substatements);
        }
        if (UsesStatementSupport.findFirstStatement(substatements, RefineEffectiveStatement.class) == null) {
            return new SimpleCopiedUsesEffectiveStatement(declared, argument, sourceGrouping, flags, substatements);
        }
        return new FullCopiedUsesEffectiveStatement(declared, argument, sourceGrouping, flags, substatements);
    }

    private static void copyFromSourceToTarget(StmtContext<?, ?, ?> sourceGrpStmtCtx, StmtContext.Mutable<?, ?, ?> targetCtx, StmtContext.Mutable<QName, UsesStatement, UsesEffectiveStatement> usesNode) {
        Collection declared = sourceGrpStmtCtx.declaredSubstatements();
        Collection effective = sourceGrpStmtCtx.effectiveSubstatements();
        ArrayList buffer = new ArrayList(declared.size() + effective.size());
        QNameModule newQNameModule = UsesStatementSupport.getNewQNameModule(targetCtx, sourceGrpStmtCtx);
        boolean unsupported = !usesNode.isSupportedByFeatures();
        for (StmtContext original : declared) {
            if (!UsesStatementSupport.shouldCopy(original)) continue;
            original.copyAsChildOf(targetCtx, CopyType.ADDED_BY_USES, newQNameModule).ifPresent(copy -> {
                if (unsupported || !original.isSupportedByFeatures() || !original.isSupportedToBuildEffective()) {
                    copy.setUnsupported();
                }
                buffer.add(copy);
            });
        }
        for (StmtContext original : effective) {
            if (!UsesStatementSupport.shouldCopy(original)) continue;
            original.copyAsChildOf(targetCtx, CopyType.ADDED_BY_USES, newQNameModule).ifPresent(buffer::add);
        }
        targetCtx.addEffectiveSubstatements(buffer);
        usesNode.addAsEffectOfStatement(buffer);
    }

    private static boolean shouldCopy(StmtContext<?, ?, ?> stmt) {
        if (SchemaTreeEffectiveStatement.class.isAssignableFrom(stmt.publicDefinition().getEffectiveRepresentationClass())) {
            return true;
        }
        return StmtContextUtils.isUnknownStatement(stmt);
    }

    private static QNameModule getNewQNameModule(StmtContext<?, ?, ?> targetCtx, StmtContext<?, ?, ?> stmtContext) {
        if (targetCtx.getParentContext() == null) {
            return (QNameModule)targetCtx.namespaceItem(ParserNamespaces.MODULECTX_TO_QNAME, targetCtx);
        }
        if (targetCtx.publicDefinition() == YangStmtMapping.AUGMENT) {
            return StmtContextUtils.getModuleQName(targetCtx);
        }
        Object object = targetCtx.argument();
        if (object instanceof QName) {
            QName targetQName = (QName)object;
            if (stmtContext.argument() instanceof QName) {
                return targetQName.getModule();
            }
        }
        return null;
    }

    private static void performRefine(StmtContext.Mutable<?, ?, ?> refineStmtCtx, StmtContext<?, ?, ?> usesParentCtx) {
        Object refineArgument = refineStmtCtx.argument();
        if (!(refineArgument instanceof SchemaNodeIdentifier.Descendant)) {
            throw new InferenceException(refineStmtCtx, "Invalid refine argument %s. It must be instance of SchemaNodeIdentifier.", new Object[]{refineArgument});
        }
        SchemaNodeIdentifier.Descendant refineDescendant = (SchemaNodeIdentifier.Descendant)refineArgument;
        Optional optRefineTargetCtx = ParserNamespaces.findSchemaTreeStatement(usesParentCtx, (SchemaNodeIdentifier)refineDescendant);
        InferenceException.throwIf((!optRefineTargetCtx.isPresent() ? 1 : 0) != 0, refineStmtCtx, (String)"Refine target node %s not found.", (Object[])new Object[]{refineDescendant});
        StmtContext refineTargetCtx = (StmtContext)optRefineTargetCtx.orElseThrow();
        if (StmtContextUtils.isUnknownStatement((StmtContext)refineTargetCtx)) {
            LOG.trace("Refine node '{}' in uses '{}' has target node unknown statement '{}'. Refine has been skipped. At line: {}", new Object[]{refineStmtCtx.argument(), refineStmtCtx.coerceParentContext().argument(), refineTargetCtx.argument(), refineStmtCtx.sourceReference()});
        } else if (refineTargetCtx instanceof StmtContext.Mutable) {
            StmtContext.Mutable refineTarget = (StmtContext.Mutable)refineTargetCtx;
            for (StmtContext refineSubstatementCtx : refineStmtCtx.declaredSubstatements()) {
                if (!UsesStatementSupport.isSupportedRefineSubstatement(refineSubstatementCtx)) continue;
                UsesStatementSupport.addOrReplaceNode(refineSubstatementCtx, refineTarget);
            }
        } else {
            throw new VerifyException("Unexpected target " + refineTargetCtx);
        }
        if (!refineTargetCtx.isSupportedToBuildEffective() || !refineTargetCtx.isSupportedByFeatures()) {
            refineStmtCtx.setUnsupported();
        }
    }

    private static void addOrReplaceNode(StmtContext<?, ?, ?> refineSubstatementCtx, StmtContext.Mutable<?, ?, ?> refineTargetNodeCtx) {
        StatementDefinition refineSubstatementDef = refineSubstatementCtx.publicDefinition();
        SourceException.throwIf((!UsesStatementSupport.isSupportedRefineTarget(refineSubstatementCtx, refineTargetNodeCtx) ? 1 : 0) != 0, refineSubstatementCtx, (String)"Error in module '%s' in the refine of uses '%s': can not perform refine of '%s' for the target '%s'.", (Object[])new Object[]{refineSubstatementCtx.getRoot().rawArgument(), refineSubstatementCtx.coerceParentContext().argument(), refineSubstatementCtx.publicDefinition(), refineTargetNodeCtx.publicDefinition()});
        if (!UsesStatementSupport.isAllowedToAddByRefine(refineSubstatementDef)) {
            refineTargetNodeCtx.removeStatementFromEffectiveSubstatements(refineSubstatementDef);
        }
        refineTargetNodeCtx.addEffectiveSubstatement(refineSubstatementCtx.replicaAsChildOf(refineTargetNodeCtx));
    }

    private static boolean isAllowedToAddByRefine(StatementDefinition publicDefinition) {
        return YangStmtMapping.MUST.equals((Object)publicDefinition);
    }

    private static boolean isSupportedRefineSubstatement(StmtContext<?, ?, ?> refineSubstatementCtx) {
        Collection supportedRefineSubstatements = (Collection)refineSubstatementCtx.namespaceItem(ValidationBundles.NAMESPACE, (Object)ValidationBundles.ValidationBundleType.SUPPORTED_REFINE_SUBSTATEMENTS);
        return supportedRefineSubstatements == null || supportedRefineSubstatements.isEmpty() || supportedRefineSubstatements.contains(refineSubstatementCtx.publicDefinition()) || StmtContextUtils.isUnknownStatement(refineSubstatementCtx);
    }

    private static boolean isSupportedRefineTarget(StmtContext<?, ?, ?> refineSubstatementCtx, StmtContext<?, ?, ?> refineTargetNodeCtx) {
        Collection supportedRefineTargets = YangValidationBundles.SUPPORTED_REFINE_TARGETS.get(refineSubstatementCtx.publicDefinition());
        return supportedRefineTargets == null || supportedRefineTargets.isEmpty() || supportedRefineTargets.contains(refineTargetNodeCtx.publicDefinition());
    }
}

