/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.util.LinkedList;
import javax.servlet.FilterConfig;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebFilterMap;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardContext;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebStandardWrapper;

public class PaxWebScopedStandardContext
extends StandardContext {
    private final PaxWebStandardWrapper wrapper;
    private final PaxWebStandardContext delegate;

    public PaxWebScopedStandardContext(PaxWebStandardWrapper paxWebStandardWrapper, PaxWebStandardContext delegate) {
        this.wrapper = paxWebStandardWrapper;
        this.delegate = delegate;
        this.setName(delegate.getName());
        this.setPath(delegate.getPath());
    }

    @Override
    public FilterMap[] findFilterMaps() {
        FilterMap[] maps = this.delegate.findFilterMaps();
        OsgiContextModel targetContext = this.wrapper.getOsgiContextModel();
        if (targetContext == null) {
            targetContext = this.delegate.getDefaultOsgiContextModel();
        }
        LinkedList<FilterMap> osgiScopedFilters = new LinkedList<FilterMap>();
        for (FilterMap filter : maps) {
            PaxWebFilterMap fDef = (PaxWebFilterMap)filter;
            if (!fDef.isInitial() && !fDef.getFilterModel().getContextModels().contains(targetContext)) continue;
            osgiScopedFilters.add(filter);
        }
        return osgiScopedFilters.toArray(new FilterMap[0]);
    }

    @Override
    public FilterDef findFilterDef(String filterName) {
        return this.delegate.findFilterDef(filterName);
    }

    @Override
    public FilterConfig findFilterConfig(String name) {
        return this.delegate.findFilterConfig(name);
    }

    @Override
    public LifecycleState getState() {
        return this.delegate.getState();
    }

    @Override
    public Container getParent() {
        return this.delegate.getParent();
    }

    @Override
    public String getPath() {
        return this.delegate.getPath();
    }

    @Override
    public String getEncodedPath() {
        return this.delegate.getEncodedPath();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

