/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.catalina.Executor;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardThreadExecutor;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.ConnectorCreateRule;
import org.apache.catalina.startup.ContextConfig;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.config.SecurityConfiguration;
import org.ops4j.pax.web.service.spi.config.ServerConfiguration;
import org.ops4j.pax.web.service.tomcat.internal.PaxWebHttp11Nio2Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class TomcatFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatFactory.class);
    private final ClassLoader classLoader;
    private boolean alpnAvailable;
    private boolean http2Available;

    TomcatFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.discovery();
    }

    private void discovery() {
        this.alpnAvailable = JreCompat.isJre9Available();
        try {
            this.classLoader.loadClass("org.apache.coyote.http2.Http2Protocol");
            this.http2Available = true;
        }
        catch (ClassNotFoundException e) {
            this.http2Available = false;
        }
    }

    public Executor createThreadPool(Configuration configuration) {
        Integer idleTimeout;
        Integer minThreads;
        ServerConfiguration sc = configuration.server();
        Integer maxThreads = sc.getServerMaxThreads();
        if (maxThreads == null) {
            maxThreads = 200;
        }
        if ((minThreads = sc.getServerMinThreads()) == null) {
            minThreads = Math.min(8, maxThreads);
        }
        if ((idleTimeout = sc.getServerIdleTimeout()) == null) {
            idleTimeout = 60000;
        }
        String prefix = sc.getServerThreadNamePrefix();
        StandardThreadExecutor executor = new StandardThreadExecutor();
        executor.setName("default");
        executor.setMaxThreads(maxThreads);
        executor.setMinSpareThreads(minThreads);
        executor.setMaxIdleTime(idleTimeout);
        if (prefix != null) {
            executor.setNamePrefix(prefix);
        }
        return executor;
    }

    public Connector createDefaultConnector(Server server, String address, Executor executor, Configuration configuration) {
        ServerConfiguration sc = configuration.server();
        Connector defaultConnector = new Connector("org.ops4j.pax.web.service.tomcat.internal.PaxWebHttp11Nio2Protocol");
        defaultConnector.setProperty("PaxWebConnectorName", sc.getHttpConnectorName());
        defaultConnector.setProperty("address", address);
        defaultConnector.setPort(sc.getHttpPort());
        defaultConnector.setScheme("http");
        defaultConnector.setSecure(false);
        if (sc.isHttpSecureEnabled().booleanValue()) {
            defaultConnector.setRedirectPort(sc.getHttpSecurePort());
        }
        PaxWebHttp11Nio2Protocol protocol = (PaxWebHttp11Nio2Protocol)defaultConnector.getProtocolHandler();
        defaultConnector.setXpoweredBy(false);
        defaultConnector.setAllowTrace(false);
        protocol.setServer(null);
        protocol.setServerRemoveAppProvidedValues(true);
        if (sc.getConnectorIdleTimeout() != null) {
            defaultConnector.setProperty("connectionTimeout", sc.getConnectorIdleTimeout().toString());
        }
        if (this.http2Available) {
            LOG.info("HTTP/2 ClearText support available, adding \"h2c\" protocol support to default connector");
            defaultConnector.addUpgradeProtocol(new Http2Protocol());
        }
        LOG.info("Default Tomcat connector created: {}", (Object)defaultConnector);
        return defaultConnector;
    }

    public Connector createSecureConnector(Server server, String address, Executor executor, Configuration configuration) {
        String sslTruststore;
        String sslKeystore;
        ServerConfiguration sc = configuration.server();
        SecurityConfiguration secc = configuration.security();
        Connector secureConnector = new Connector("org.ops4j.pax.web.service.tomcat.internal.PaxWebHttp11Nio2Protocol");
        secureConnector.setProperty("PaxWebConnectorName", sc.getHttpSecureConnectorName());
        secureConnector.setProperty("address", address);
        secureConnector.setPort(sc.getHttpSecurePort());
        secureConnector.setScheme("https");
        secureConnector.setSecure(true);
        secureConnector.setProperty("SSLEnabled", "true");
        PaxWebHttp11Nio2Protocol protocol = (PaxWebHttp11Nio2Protocol)secureConnector.getProtocolHandler();
        protocol.setSslImplementationName("org.apache.tomcat.util.net.jsse.JSSEImplementation");
        secureConnector.setXpoweredBy(false);
        secureConnector.setAllowTrace(false);
        protocol.setServer(null);
        protocol.setServerRemoveAppProvidedValues(true);
        if (sc.getConnectorIdleTimeout() != null) {
            secureConnector.setProperty("connectionTimeout", sc.getConnectorIdleTimeout().toString());
        }
        if ((sslKeystore = secc.getSslKeystore()) != null) {
            protocol.setKeystoreFile(sslKeystore);
        }
        if (secc.getSslKeystorePassword() != null) {
            protocol.setKeystorePass(secc.getSslKeystorePassword());
        }
        if (secc.getSslKeyPassword() != null) {
            protocol.setKeyPass(secc.getSslKeyPassword());
        }
        if (secc.getSslKeyManagerFactoryAlgorithm() != null) {
            LOG.debug("Not supported SSL Key Algorithm parameter");
        }
        if (secc.getSslKeyAlias() != null) {
            protocol.setKeyAlias(secc.getSslKeyAlias());
        }
        if (secc.getSslKeystoreType() != null) {
            protocol.setKeystoreType(secc.getSslKeystoreType());
        }
        if (secc.getSslKeystoreProvider() != null && !"".equals(secc.getSslKeystoreProvider().trim())) {
            protocol.setKeystoreProvider(secc.getSslKeystoreProvider());
        }
        if ((sslTruststore = secc.getTruststore()) != null) {
            protocol.setTruststoreFile(sslTruststore);
        }
        if (secc.getTruststorePassword() != null) {
            protocol.setTruststorePass(secc.getTruststorePassword());
        }
        if (secc.getTruststoreType() != null) {
            protocol.setTruststoreType(secc.getTruststoreType());
        }
        if (secc.getTruststoreProvider() != null && !"".equals(secc.getTruststoreProvider().trim())) {
            protocol.setTruststoreProvider(secc.getTruststoreProvider());
        }
        if (secc.getTrustManagerFactoryAlgorithm() != null) {
            protocol.setTruststoreAlgorithm(secc.getTrustManagerFactoryAlgorithm());
        }
        if (secc.isClientAuthWanted() != null && secc.isClientAuthWanted().booleanValue()) {
            protocol.setClientAuth("want");
        }
        if (secc.isClientAuthNeeded() != null && secc.isClientAuthNeeded().booleanValue()) {
            protocol.setClientAuth("require");
        }
        String[] supportedProtocols = new String[]{};
        String[] supportedCipherSuites = new String[]{};
        try {
            SSLParameters params = SSLContext.getDefault().getSupportedSSLParameters();
            supportedProtocols = params.getProtocols();
            supportedCipherSuites = params.getCipherSuites();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Problem checking supported protocols and ciphers suites: " + e.getMessage(), e);
        }
        if (secc.getProtocolsIncluded().length > 0) {
            protocol.setSslEnabledProtocols(String.join((CharSequence)",", secc.getProtocolsIncluded()));
        }
        if (secc.getCiphersuiteIncluded().length > 0) {
            protocol.setSSLCipherSuite(String.join((CharSequence)":", secc.getCiphersuiteIncluded()));
        }
        if (secc.getSslProtocol() != null) {
            protocol.setSSLProtocol(secc.getSslProtocol());
        }
        if (secc.getSecureRandomAlgorithm() != null) {
            LOG.debug("Not supported Secure Random Algorithm parameter");
        }
        protocol.setUseServerCipherSuitesOrder(true);
        if (secc.isSslRenegotiationAllowed() != null) {
            LOG.debug("Not supported SSL Renegotiation Allowed parameter");
        }
        if (secc.getSslRenegotiationLimit() != null) {
            LOG.debug("Not supported SSL Renegotiation Limit parameter");
        }
        if (secc.getSslSessionsEnabled() != null && !secc.getSslSessionsEnabled().booleanValue()) {
            protocol.setSessionCacheSize(0);
        } else if (secc.getSslSessionCacheSize() != null) {
            protocol.setSessionCacheSize(secc.getSslSessionCacheSize());
        }
        if (secc.getSslSessionTimeout() != null) {
            protocol.setSessionTimeout(secc.getSslSessionTimeout());
        }
        if (this.http2Available) {
            LOG.info("HTTP/2 support available, adding \"h2\" protocol support to secure connector");
            secureConnector.addUpgradeProtocol(new Http2Protocol());
        }
        LOG.info("Secure Tomcat connector created: {}", (Object)secureConnector);
        return secureConnector;
    }

    public Digester createServerDigester(Configuration configuration) {
        Digester digester = new PaxWebCatalina().createStartDigester();
        digester.getRules().match("", "Server").add(new BaseDirsRule(digester));
        List rules = digester.getRules().match("", "Server/Service/Connector");
        int idx = 0;
        Iterator iterator = rules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (rule instanceof ConnectorCreateRule) {
                iterator.remove();
                break;
            }
            ++idx;
        }
        rules.add(idx, new PaxWebConnectorCreateRule(digester));
        rules.add(new PaxWebConnectorSetName(digester, configuration.server()));
        return digester;
    }

    public Digester createContextDigester() {
        return new PaxWebCatalinaContextConfig().createContextDigester();
    }

    private static class PaxWebConnectorSetName
    extends Rule {
        private final ServerConfiguration serverConfiguration;

        PaxWebConnectorSetName(Digester digester, ServerConfiguration server) {
            this.digester = digester;
            this.serverConfiguration = server;
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            Object connector = this.digester.peek();
            if (connector instanceof Connector) {
                String connectorName = attributes.getValue("name");
                if (connectorName == null || "".equals(connectorName.trim())) {
                    connectorName = ((Connector)connector).getSecure() ? this.serverConfiguration.getHttpSecureConnectorName() : this.serverConfiguration.getHttpConnectorName();
                }
                ((PaxWebHttp11Nio2Protocol)((Connector)connector).getProtocolHandler()).setPaxWebConnectorName(connectorName);
            }
        }
    }

    private static class PaxWebConnectorCreateRule
    extends ConnectorCreateRule {
        PaxWebConnectorCreateRule(Digester digester) {
            this.digester = digester;
        }

        @Override
        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            String protocolName = attributes.getValue("protocol");
            if (protocolName == null || "HTTP/1.1".equals(protocolName) || "org.apache.coyote.http11.Http11NioProtocol".equals(protocolName) || "org.apache.coyote.http11.Http11Nio2Protocol".equals(protocolName)) {
                int idx = attributes.getIndex("protocol");
                attributes = new AttributesImpl(attributes);
                ((AttributesImpl)attributes).setValue(idx, "org.ops4j.pax.web.service.tomcat.internal.PaxWebHttp11Nio2Protocol");
            }
            super.begin(namespace, name, attributes);
        }
    }

    private static class BaseDirsRule
    extends Rule {
        BaseDirsRule(Digester digester) {
            this.digester = digester;
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            Object top = this.digester.peek();
            if (top instanceof StandardServer) {
                String base;
                String home = attributes.getValue("catalinaHome");
                if (home != null && !"".equals(home)) {
                    boolean ok = false;
                    File catalinaHome = new File(home);
                    if (catalinaHome.isFile()) {
                        LOG.warn("Can't set catalina home to {}. It is an existing file.", (Object)home);
                    } else if (!catalinaHome.isDirectory()) {
                        if (!catalinaHome.mkdirs()) {
                            LOG.warn("Can't set catalina home to {}. Can't create directory.", (Object)home);
                        } else {
                            ok = true;
                        }
                    } else {
                        ok = true;
                    }
                    if (ok) {
                        ((StandardServer)top).setCatalinaHome(new File(home));
                    }
                }
                if ((base = attributes.getValue("catalinaBase")) != null && !"".equals(base)) {
                    boolean ok = false;
                    File catalinaBase = new File(base);
                    if (catalinaBase.isFile()) {
                        LOG.warn("Can't set catalina base to {}. It is an existing file.", (Object)base);
                    } else if (!catalinaBase.isDirectory()) {
                        if (!catalinaBase.mkdirs()) {
                            LOG.warn("Can't set catalina base to {}. Can't create directory.", (Object)base);
                        } else {
                            ok = true;
                        }
                    } else {
                        ok = true;
                    }
                    if (ok) {
                        ((StandardServer)top).setCatalinaBase(new File(base));
                    }
                }
            }
            super.begin(namespace, name, attributes);
        }
    }

    public static class ServerHolder {
        private Server server;

        public Server getServer() {
            return this.server;
        }

        public void setServer(Server server) {
            this.server = server;
        }
    }

    private static class PaxWebCatalinaContextConfig
    extends ContextConfig {
        PaxWebCatalinaContextConfig() {
        }

        @Override
        public Digester createContextDigester() {
            return super.createContextDigester();
        }
    }

    private static class PaxWebCatalina
    extends Catalina {
        PaxWebCatalina() {
        }

        @Override
        public Digester createStartDigester() {
            Digester digester = super.createStartDigester();
            digester.setClassLoader(PaxWebCatalina.class.getClassLoader());
            return digester;
        }
    }
}

