/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.BackupDatastoreInput;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint32;

public class BackupDatastoreInputBuilder {
    private String _filePath;
    private Uint32 _timeout;
    Map<Class<? extends Augmentation<BackupDatastoreInput>>, Augmentation<BackupDatastoreInput>> augmentation = Map.of();

    public BackupDatastoreInputBuilder() {
    }

    public BackupDatastoreInputBuilder(BackupDatastoreInput base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BackupDatastoreInput>>, Augmentation<BackupDatastoreInput>>(aug);
        }
        this._filePath = base.getFilePath();
        this._timeout = base.getTimeout();
    }

    public String getFilePath() {
        return this._filePath;
    }

    public Uint32 getTimeout() {
        return this._timeout;
    }

    public <E$$ extends Augmentation<BackupDatastoreInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BackupDatastoreInputBuilder setFilePath(String value) {
        this._filePath = value;
        return this;
    }

    private static void checkTimeoutRange(long value) {
        if (value >= 1L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..4294967295]]", (long)value);
    }

    public BackupDatastoreInputBuilder setTimeout(Uint32 value) {
        if (value != null) {
            BackupDatastoreInputBuilder.checkTimeoutRange(value.longValue());
        }
        this._timeout = value;
        return this;
    }

    public BackupDatastoreInputBuilder addAugmentation(Augmentation<BackupDatastoreInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BackupDatastoreInput>>, Augmentation<BackupDatastoreInput>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public BackupDatastoreInputBuilder removeAugmentation(Class<? extends Augmentation<BackupDatastoreInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull BackupDatastoreInput build() {
        return new BackupDatastoreInputImpl(this);
    }

    private static final class BackupDatastoreInputImpl
    extends AbstractAugmentable<BackupDatastoreInput>
    implements BackupDatastoreInput {
        private final String _filePath;
        private final Uint32 _timeout;
        private int hash = 0;
        private volatile boolean hashValid = false;

        BackupDatastoreInputImpl(BackupDatastoreInputBuilder base) {
            super(base.augmentation);
            this._filePath = base.getFilePath();
            this._timeout = base.getTimeout();
        }

        @Override
        public String getFilePath() {
            return this._filePath;
        }

        @Override
        public Uint32 getTimeout() {
            return this._timeout;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = BackupDatastoreInput.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return BackupDatastoreInput.bindingEquals(this, obj);
        }

        public String toString() {
            return BackupDatastoreInput.bindingToString(this);
        }
    }
}

