/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.collect.Interner;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.opendaylight.yangtools.yang.data.util.LeafInterner;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;

final class InterningLeafNodeBuilder<T>
extends ImmutableLeafNodeBuilder<T> {
    private final Interner<LeafNode<T>> interner;

    private InterningLeafNodeBuilder(Interner<LeafNode<T>> interner) {
        this.interner = Objects.requireNonNull(interner);
    }

    static <T> @Nullable InterningLeafNodeBuilder<T> forSchema(@Nullable DataSchemaNode schema) {
        LeafSchemaNode leafSchema;
        Optional interner;
        if (schema instanceof LeafSchemaNode && (interner = LeafInterner.forSchema((LeafSchemaNode)(leafSchema = (LeafSchemaNode)schema))).isPresent()) {
            return new InterningLeafNodeBuilder<T>((Interner)interner.orElseThrow());
        }
        return null;
    }

    @Override
    public LeafNode<T> build() {
        return (LeafNode)this.interner.intern(super.build());
    }
}

