/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMountpoints;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizationResult;
import org.opendaylight.yangtools.yang.data.impl.schema.ResultAlreadySetException;

public final class NormalizationResultHolder
implements Mutable {
    private NormalizedNode data;
    private NormalizedMetadata metadata;
    private NormalizedMountpoints mountPoints;

    public @Nullable NormalizationResult result() {
        NormalizedNode localData = this.data;
        return localData == null ? null : new NormalizationResult(localData, this.metadata, this.mountPoints);
    }

    public @NonNull NormalizationResult getResult() {
        NormalizedNode localData = this.data;
        if (localData == null) {
            throw new IllegalStateException("Holder " + this + " has not been completed");
        }
        return new NormalizationResult(localData, this.metadata, this.mountPoints);
    }

    void setData(NormalizedNode data) {
        if (this.data != null) {
            throw new ResultAlreadySetException("Normalized Node result was already set.", this.data);
        }
        this.data = Objects.requireNonNull(data);
    }

    void setMetadata(NormalizedMetadata metadata) {
        this.metadata = metadata;
    }

    void setMountPoints(NormalizedMountpoints mountPoints) {
        this.mountPoints = mountPoints;
    }

    void reset() {
        this.data = null;
        this.metadata = null;
        this.mountPoints = null;
    }
}

