/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.UnmodifiableCollection;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.AbstractNormalizedNode;

public class ImmutableUserLeafSetNodeBuilder<T>
implements ListNodeBuilder<T, UserLeafSetNode<T>> {
    private Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;
    private boolean dirty;

    ImmutableUserLeafSetNodeBuilder() {
        this.value = new LinkedHashMap<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>>();
        this.dirty = false;
    }

    ImmutableUserLeafSetNodeBuilder(ImmutableUserLeafSetNode<T> node) {
        this.nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)node.name();
        this.value = node.getChildren();
        this.dirty = true;
    }

    public static <T> @NonNull ListNodeBuilder<T, UserLeafSetNode<T>> create() {
        return new ImmutableUserLeafSetNodeBuilder<T>();
    }

    public static <T> @NonNull ListNodeBuilder<T, UserLeafSetNode<T>> create(UserLeafSetNode<T> node) {
        if (!(node instanceof ImmutableUserLeafSetNode)) {
            throw new UnsupportedOperationException("Cannot initialize from class " + node.getClass());
        }
        return new ImmutableUserLeafSetNodeBuilder<T>((ImmutableUserLeafSetNode)node);
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = new LinkedHashMap<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>>(this.value);
            this.dirty = false;
        }
    }

    public ImmutableUserLeafSetNodeBuilder<T> withChild(LeafSetEntryNode<T> child) {
        this.checkDirty();
        this.value.put(child.name(), child);
        return this;
    }

    public ImmutableUserLeafSetNodeBuilder<T> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        this.value.remove(key);
        return this;
    }

    public UserLeafSetNode<T> build() {
        this.dirty = true;
        return new ImmutableUserLeafSetNode<T>(this.nodeIdentifier, this.value);
    }

    public ImmutableUserLeafSetNodeBuilder<T> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public ImmutableUserLeafSetNodeBuilder<T> withValue(Collection<LeafSetEntryNode<T>> withValue) {
        this.checkDirty();
        for (LeafSetEntryNode<T> leafSetEntry : withValue) {
            this.withChild((LeafSetEntryNode)leafSetEntry);
        }
        return this;
    }

    public ImmutableUserLeafSetNodeBuilder<T> withChildValue(T childValue) {
        return this.withChild((LeafSetEntryNode)ImmutableLeafSetEntryNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(this.nodeIdentifier.getNodeType(), childValue)).withValue(childValue).build());
    }

    public ImmutableUserLeafSetNodeBuilder<T> addChild(LeafSetEntryNode<T> child) {
        return this.withChild((LeafSetEntryNode)child);
    }

    public ImmutableUserLeafSetNodeBuilder<T> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableUserLeafSetNode<T>
    extends AbstractNormalizedNode<YangInstanceIdentifier.NodeIdentifier, UserLeafSetNode<?>>
    implements UserLeafSetNode<T> {
        private final Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> children;

        ImmutableUserLeafSetNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> children) {
            super((YangInstanceIdentifier.PathArgument)nodeIdentifier);
            this.children = children;
        }

        public LeafSetEntryNode<T> childByArg(YangInstanceIdentifier.NodeWithValue child) {
            return this.children.get(child);
        }

        public LeafSetEntryNode<T> childAt(int position) {
            return (LeafSetEntryNode)Iterables.get(this.children.values(), (int)position);
        }

        public int size() {
            return this.children.size();
        }

        public Collection<LeafSetEntryNode<T>> body() {
            return UnmodifiableCollection.create(this.children.values());
        }

        protected Class<UserLeafSetNode<?>> implementedType() {
            return UserLeafSetNode.class;
        }

        protected int valueHashCode() {
            return this.children.hashCode();
        }

        protected boolean valueEquals(UserLeafSetNode<?> other) {
            if (other instanceof ImmutableUserLeafSetNode) {
                ImmutableUserLeafSetNode immutableOther = (ImmutableUserLeafSetNode)other;
                return this.children.equals(immutableOther.children);
            }
            return Iterables.elementsEqual(this.children.values(), (Iterable)other.body());
        }

        private Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> getChildren() {
            return Collections.unmodifiableMap(this.children);
        }
    }
}

