/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.nodes;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.LazyLeafOperations;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.LazyValues;
import org.opendaylight.yangtools.yang.data.spi.node.AbstractNormalizedNode;

public abstract class AbstractImmutableDataContainerNode<K extends YangInstanceIdentifier.PathArgument, N extends DataContainerNode>
extends AbstractNormalizedNode<K, N>
implements DataContainerNode {
    private final Map<YangInstanceIdentifier.NodeIdentifier, Object> children;

    protected AbstractImmutableDataContainerNode(Map<YangInstanceIdentifier.NodeIdentifier, Object> children, K nodeIdentifier) {
        super(nodeIdentifier);
        this.children = ImmutableOffsetMap.unorderedCopyOf(children);
    }

    public final DataContainerChild childByArg(YangInstanceIdentifier.NodeIdentifier child) {
        return LazyLeafOperations.getChild(this.children, child);
    }

    public final Collection<DataContainerChild> body() {
        return new LazyValues(this.children);
    }

    public final int size() {
        return this.children.size();
    }

    public final Map<YangInstanceIdentifier.NodeIdentifier, Object> getChildren() {
        return this.children;
    }

    protected int valueHashCode() {
        return this.children.hashCode();
    }

    protected boolean valueEquals(N other) {
        if (other instanceof AbstractImmutableDataContainerNode) {
            AbstractImmutableDataContainerNode immutableContainer = (AbstractImmutableDataContainerNode)((Object)other);
            return this.children.equals(immutableContainer.children);
        }
        if (this.size() != other.size()) {
            return false;
        }
        Iterator iterator = this.body().iterator();
        while (iterator.hasNext()) {
            DataContainerChild child = (DataContainerChild)iterator.next();
            if (child.equals(other.childByArg((YangInstanceIdentifier.PathArgument)child.name()))) continue;
            return false;
        }
        return true;
    }
}

