/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.nodes;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;

@Beta
public final class LazyLeafOperations {
    private LazyLeafOperations() {
    }

    public static @Nullable DataContainerChild getChild(Map<YangInstanceIdentifier.NodeIdentifier, Object> map, YangInstanceIdentifier.NodeIdentifier key) {
        Object value = map.get(key);
        return value == null ? null : LazyLeafOperations.decodeChild(key, value);
    }

    public static void putChild(Map<YangInstanceIdentifier.NodeIdentifier, Object> map, DataContainerChild child) {
        DataContainerChild node = Objects.requireNonNull(child);
        map.put(node.name(), LazyLeafOperations.encodeExpendableChild(node));
    }

    static @NonNull LeafNode<?> coerceLeaf(YangInstanceIdentifier.NodeIdentifier key, Object value) {
        return ImmutableNodes.leafNode(key, value);
    }

    private static @Nullable DataContainerChild decodeChild(YangInstanceIdentifier.NodeIdentifier key, @NonNull Object value) {
        return LazyLeafOperations.decodeExpendableChild(key, value);
    }

    private static @NonNull DataContainerChild decodeExpendableChild(YangInstanceIdentifier.NodeIdentifier key, @NonNull Object value) {
        DataContainerChild child;
        return value instanceof DataContainerChild ? (child = (DataContainerChild)value) : LazyLeafOperations.coerceLeaf(key, value);
    }

    private static @NonNull Object encodeExpendableChild(@NonNull DataContainerChild node) {
        Object object;
        if (node instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)node;
            object = LazyLeafOperations.verifyEncode(leafNode.body());
        } else {
            object = node;
        }
        return object;
    }

    private static @NonNull Object verifyEncode(@NonNull Object value) {
        Verify.verify((!(value instanceof DataContainerChild) ? 1 : 0) != 0, (String)"Unexpected leaf value %s", (Object)value);
        return value;
    }
}

