/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster;

import akka.japi.Procedure;
import akka.persistence.JournalProtocol;
import akka.persistence.SnapshotProtocol;
import akka.persistence.SnapshotSelectionCriteria;
import java.util.Objects;
import org.opendaylight.controller.cluster.DataPersistenceProvider;
import org.opendaylight.controller.cluster.common.actor.ExecuteInSelfActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonPersistentDataProvider
implements DataPersistenceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NonPersistentDataProvider.class);
    private final ExecuteInSelfActor actor;

    public NonPersistentDataProvider(ExecuteInSelfActor actor) {
        this.actor = Objects.requireNonNull(actor);
    }

    @Override
    public boolean isRecoveryApplicable() {
        return false;
    }

    @Override
    public <T> void persist(T entry, Procedure<T> procedure) {
        NonPersistentDataProvider.invokeProcedure(procedure, entry);
    }

    @Override
    public <T> void persistAsync(T entry, Procedure<T> procedure) {
        this.actor.executeInSelf(() -> NonPersistentDataProvider.invokeProcedure(procedure, entry));
    }

    @Override
    public void saveSnapshot(Object snapshot) {
    }

    @Override
    public void deleteSnapshots(SnapshotSelectionCriteria criteria) {
    }

    @Override
    public void deleteMessages(long sequenceNumber) {
    }

    @Override
    public long getLastSequenceNumber() {
        return -1L;
    }

    static <T> void invokeProcedure(Procedure<T> procedure, T argument) {
        try {
            procedure.apply(argument);
        }
        catch (Exception e) {
            LOG.error("An unexpected error occurred", (Throwable)e);
        }
    }

    @Override
    public boolean handleJournalResponse(JournalProtocol.Response response) {
        return false;
    }

    @Override
    public boolean handleSnapshotResponse(SnapshotProtocol.Response response) {
        return false;
    }
}

