/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster;

import akka.japi.Procedure;
import akka.persistence.AbstractPersistentActor;
import akka.persistence.DeleteMessagesSuccess;
import akka.persistence.DeleteSnapshotsSuccess;
import akka.persistence.JournalProtocol;
import akka.persistence.SnapshotProtocol;
import akka.persistence.SnapshotSelectionCriteria;
import java.util.Objects;
import org.opendaylight.controller.cluster.DataPersistenceProvider;

public class PersistentDataProvider
implements DataPersistenceProvider {
    private final AbstractPersistentActor persistentActor;

    public PersistentDataProvider(AbstractPersistentActor persistentActor) {
        this.persistentActor = Objects.requireNonNull(persistentActor, "persistentActor can't be null");
    }

    @Override
    public boolean isRecoveryApplicable() {
        return true;
    }

    @Override
    public <T> void persist(T entry, Procedure<T> procedure) {
        this.persistentActor.persist(entry, procedure);
    }

    @Override
    public <T> void persistAsync(T entry, Procedure<T> procedure) {
        this.persistentActor.persistAsync(entry, procedure);
    }

    @Override
    public void saveSnapshot(Object snapshot) {
        this.persistentActor.saveSnapshot(snapshot);
    }

    @Override
    public void deleteSnapshots(SnapshotSelectionCriteria criteria) {
        this.persistentActor.deleteSnapshots(criteria);
    }

    @Override
    public void deleteMessages(long sequenceNumber) {
        this.persistentActor.deleteMessages(sequenceNumber);
    }

    @Override
    public long getLastSequenceNumber() {
        return this.persistentActor.lastSequenceNr();
    }

    @Override
    public boolean handleJournalResponse(JournalProtocol.Response response) {
        return response instanceof DeleteMessagesSuccess;
    }

    @Override
    public boolean handleSnapshotResponse(SnapshotProtocol.Response response) {
        return response instanceof DeleteSnapshotsSuccess;
    }
}

