/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.cluster.common.actor.AkkaConfigurationReader;
import org.opendaylight.controller.cluster.common.actor.UnifiedConfig;

public abstract class AbstractConfig
implements UnifiedConfig {
    private final Config config;

    public AbstractConfig(Config config) {
        this.config = config;
    }

    @Override
    public Config get() {
        return this.config;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Map<String, Object> configHolder;
        protected Config fallback;
        private final String actorSystemName;

        public Builder(String actorSystemName) {
            Preconditions.checkArgument((actorSystemName != null ? 1 : 0) != 0, (Object)"Actor system name must not be null");
            this.actorSystemName = actorSystemName;
            this.configHolder = new HashMap<String, Object>();
        }

        public T withConfigReader(AkkaConfigurationReader reader) {
            this.fallback = reader.read().getConfig(this.actorSystemName);
            return (T)this;
        }

        protected Config merge() {
            Config config = ConfigFactory.parseMap(this.configHolder);
            if (this.fallback != null) {
                config = config.withFallback((ConfigMergeable)this.fallback);
            }
            return config;
        }
    }
}

