/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.schema.provider.impl;

import com.google.common.annotations.Beta;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.Serializable;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

@Beta
public class YangTextSchemaSourceSerializationProxy
implements Serializable {
    private static final long serialVersionUID = -6361268518176019477L;
    private final String schemaSource;
    private final Revision revision;
    private final String name;

    public YangTextSchemaSourceSerializationProxy(YangTextSchemaSource source) throws IOException {
        SourceIdentifier id = source.getIdentifier();
        this.revision = id.revision();
        this.name = id.name().getLocalName();
        this.schemaSource = source.read();
    }

    public YangTextSchemaSource getRepresentation() {
        return YangTextSchemaSource.delegateForCharSource((SourceIdentifier)new SourceIdentifier(UnresolvedQName.Unqualified.of((String)this.name), this.revision), (CharSource)CharSource.wrap((CharSequence)this.schemaSource));
    }
}

