/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class FixedYangInstanceIdentifier
extends YangInstanceIdentifier
implements Cloneable {
    static final @NonNull FixedYangInstanceIdentifier EMPTY_INSTANCE = new FixedYangInstanceIdentifier((ImmutableList<YangInstanceIdentifier.PathArgument>)ImmutableList.of());
    private static final long serialVersionUID = 1L;
    private final @NonNull ImmutableList<YangInstanceIdentifier.PathArgument> path;
    private volatile transient YangInstanceIdentifier parent = null;

    FixedYangInstanceIdentifier(ImmutableList<YangInstanceIdentifier.PathArgument> path) {
        this.path = Objects.requireNonNull(path, "path must not be null.");
    }

    @Override
    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public FixedYangInstanceIdentifier clone() {
        try {
            return (FixedYangInstanceIdentifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("clone() should be supported", e);
        }
    }

    @Override
    public YangInstanceIdentifier getParent() {
        if (this.path.isEmpty()) {
            return null;
        }
        YangInstanceIdentifier ret = this.parent;
        if (ret == null) {
            this.parent = ret = YangInstanceIdentifier.of((ImmutableList<YangInstanceIdentifier.PathArgument>)this.path.subList(0, this.path.size() - 1));
        }
        return ret;
    }

    @Override
    public YangInstanceIdentifier coerceParent() {
        return (YangInstanceIdentifier)Verify.verifyNotNull((Object)this.getParent(), (String)"Empty instance identifier does not have a parent", (Object[])new Object[0]);
    }

    @Override
    public YangInstanceIdentifier getAncestor(int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"Negative depth is not allowed");
        Preconditions.checkArgument((depth <= this.path.size() ? 1 : 0) != 0, (String)"Depth %s exceeds maximum depth %s", (int)depth, (int)this.path.size());
        if (depth == this.path.size()) {
            return this;
        }
        if (depth == this.path.size() - 1) {
            return (YangInstanceIdentifier)Verify.verifyNotNull((Object)this.getParent());
        }
        return YangInstanceIdentifier.of((ImmutableList<YangInstanceIdentifier.PathArgument>)this.path.subList(0, depth));
    }

    public ImmutableList<YangInstanceIdentifier.PathArgument> getPathArguments() {
        return this.path;
    }

    public ImmutableList<YangInstanceIdentifier.PathArgument> getReversePathArguments() {
        return this.path.reverse();
    }

    @NonNull ImmutableList<YangInstanceIdentifier.PathArgument> tryPathArguments() {
        return this.path;
    }

    @NonNull ImmutableList<YangInstanceIdentifier.PathArgument> tryReversePathArguments() {
        return this.getReversePathArguments();
    }

    @Override
    public YangInstanceIdentifier.PathArgument getLastPathArgument() {
        return this.path.isEmpty() ? null : (YangInstanceIdentifier.PathArgument)this.path.get(this.path.size() - 1);
    }

    @Override
    YangInstanceIdentifier createRelativeIdentifier(int skipFromRoot) {
        return skipFromRoot == this.path.size() ? EMPTY_INSTANCE : new FixedYangInstanceIdentifier((ImmutableList<YangInstanceIdentifier.PathArgument>)this.path.subList(skipFromRoot, this.path.size()));
    }

    @Override
    int computeHashCode() {
        int ret = 1;
        for (YangInstanceIdentifier.PathArgument arg : this.path) {
            ret = HashCodeBuilder.nextHashCode((int)ret, (Object)arg);
        }
        return ret;
    }

    @Override
    public FixedYangInstanceIdentifier toOptimized() {
        return this;
    }
}

