/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.yang.data.api.FixedYangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.StackedPathArguments;
import org.opendaylight.yangtools.yang.data.api.StackedReversePathArguments;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class StackedYangInstanceIdentifier
extends YangInstanceIdentifier
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private final @NonNull YangInstanceIdentifier parent;
    private final @NonNull YangInstanceIdentifier.PathArgument pathArgument;
    private volatile transient StackedPathArguments pathArguments;
    private volatile transient StackedReversePathArguments reversePathArguments;

    StackedYangInstanceIdentifier(YangInstanceIdentifier parent, YangInstanceIdentifier.PathArgument pathArgument) {
        this.parent = Objects.requireNonNull(parent);
        this.pathArgument = Objects.requireNonNull(pathArgument);
    }

    public StackedYangInstanceIdentifier clone() {
        try {
            return (StackedYangInstanceIdentifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("clone() should be supported", e);
        }
    }

    @Override
    public @NonNull YangInstanceIdentifier getParent() {
        return this.parent;
    }

    @Override
    public YangInstanceIdentifier coerceParent() {
        return this.parent;
    }

    @Override
    public YangInstanceIdentifier getAncestor(int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0, (Object)"Steps cannot be negative");
        int stackedDepth = 1;
        YangInstanceIdentifier wlk = this.getParent();
        while (wlk instanceof StackedYangInstanceIdentifier) {
            wlk = wlk.getParent();
            ++stackedDepth;
        }
        int fixedDepth = wlk.getPathArguments().size();
        if (fixedDepth >= depth) {
            return wlk.getAncestor(depth);
        }
        int ourDepth = stackedDepth + fixedDepth;
        Preconditions.checkArgument((depth <= ourDepth ? 1 : 0) != 0, (String)"Depth %s exceeds maximum depth %s", (int)depth, (int)ourDepth);
        int toWalk = ourDepth - depth;
        YangInstanceIdentifier result = this;
        for (int i = 0; i < toWalk; ++i) {
            result = (YangInstanceIdentifier)Verify.verifyNotNull((Object)((YangInstanceIdentifier)result).getParent());
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public List<YangInstanceIdentifier.PathArgument> getPathArguments() {
        StackedPathArguments ret = this.tryPathArguments();
        if (ret == null) {
            StackedYangInstanceIdentifier stacked;
            ArrayList<YangInstanceIdentifier.PathArgument> stack = new ArrayList<YangInstanceIdentifier.PathArgument>();
            YangInstanceIdentifier current = this;
            do {
                Verify.verify((boolean)(current instanceof StackedYangInstanceIdentifier));
                stacked = current;
                stack.add(stacked.getLastPathArgument());
            } while ((current = stacked.getParent()).tryPathArguments() == null);
            this.pathArguments = ret = new StackedPathArguments(current, Lists.reverse(stack));
        }
        return ret;
    }

    @Override
    public List<YangInstanceIdentifier.PathArgument> getReversePathArguments() {
        StackedReversePathArguments ret = this.tryReversePathArguments();
        if (ret == null) {
            this.reversePathArguments = ret = new StackedReversePathArguments(this);
        }
        return ret;
    }

    @Override
    public YangInstanceIdentifier.PathArgument getLastPathArgument() {
        return this.pathArgument;
    }

    StackedPathArguments tryPathArguments() {
        return this.pathArguments;
    }

    StackedReversePathArguments tryReversePathArguments() {
        return this.reversePathArguments;
    }

    @Override
    YangInstanceIdentifier createRelativeIdentifier(int skipFromRoot) {
        return YangInstanceIdentifier.of(Iterables.skip(this.getPathArguments(), (int)skipFromRoot));
    }

    @Override
    int computeHashCode() {
        return HashCodeBuilder.nextHashCode((int)this.parent.hashCode(), (Object)this.pathArgument);
    }

    @Override
    boolean pathArgumentsEqual(YangInstanceIdentifier other) {
        if (other instanceof StackedYangInstanceIdentifier) {
            StackedYangInstanceIdentifier stacked = (StackedYangInstanceIdentifier)other;
            return this.pathArgument.equals(stacked.pathArgument) && this.parent.equals(stacked.parent);
        }
        return super.pathArgumentsEqual(other);
    }

    @Override
    public YangInstanceIdentifier toOptimized() {
        return FixedYangInstanceIdentifier.of(this.getPathArguments());
    }
}

