/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnydataNode;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class NormalizedNodeWriter
implements Closeable,
Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedNodeWriter.class);
    private final @NonNull NormalizedNodeStreamWriter writer;

    protected NormalizedNodeWriter(NormalizedNodeStreamWriter writer) {
        this.writer = Objects.requireNonNull(writer);
    }

    protected final NormalizedNodeStreamWriter getWriter() {
        return this.writer;
    }

    public static NormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer) {
        return NormalizedNodeWriter.forStreamWriter(writer, true);
    }

    public static NormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves) {
        return orderKeyLeaves ? new OrderedNormalizedNodeWriter(writer) : new NormalizedNodeWriter(writer);
    }

    public NormalizedNodeWriter write(NormalizedNode node) throws IOException {
        if (this.wasProcessedAsCompositeNode(node)) {
            return this;
        }
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected boolean wasProcessAsSimpleNode(NormalizedNode node) throws IOException {
        if (node instanceof LeafSetEntryNode) {
            LeafSetEntryNode nodeAsLeafList = (LeafSetEntryNode)node;
            this.writer.startLeafSetEntryNode((YangInstanceIdentifier.NodeWithValue<?>)nodeAsLeafList.name());
            this.writer.scalarValue(nodeAsLeafList.body());
            this.writer.endNode();
            return true;
        }
        if (node instanceof LeafNode) {
            LeafNode nodeAsLeaf = (LeafNode)node;
            this.writer.startLeafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.name());
            this.writer.scalarValue(nodeAsLeaf.body());
            this.writer.endNode();
            return true;
        }
        if (node instanceof AnyxmlNode) {
            AnyxmlNode anyxmlNode = (AnyxmlNode)node;
            Class model = anyxmlNode.bodyObjectModel();
            if (this.writer.startAnyxmlNode(anyxmlNode.name(), model)) {
                Object value = node.body();
                if (DOMSource.class.isAssignableFrom(model)) {
                    Verify.verify((boolean)(value instanceof DOMSource), (String)"Inconsistent anyxml node %s", (Object)anyxmlNode);
                    this.writer.domSourceValue((DOMSource)value);
                } else {
                    this.writer.scalarValue(value);
                }
                this.writer.endNode();
                return true;
            }
            LOG.debug("Ignoring unhandled anyxml node {}", (Object)anyxmlNode);
        } else if (node instanceof AnydataNode) {
            AnydataNode anydata = (AnydataNode)node;
            Class model = anydata.bodyObjectModel();
            if (this.writer.startAnydataNode(anydata.name(), model)) {
                this.writer.scalarValue(anydata.body());
                this.writer.endNode();
                return true;
            }
            LOG.debug("Writer {} does not support anydata in form of {}", (Object)this.writer, model);
        }
        return false;
    }

    protected boolean writeChildren(Iterable<? extends NormalizedNode> children) throws IOException {
        for (NormalizedNode normalizedNode : children) {
            this.write(normalizedNode);
        }
        this.writer.endNode();
        return true;
    }

    protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
        this.writer.startMapEntryNode(node.name(), node.size());
        return this.writeChildren((Iterable<? extends NormalizedNode>)node.body());
    }

    protected boolean wasProcessedAsCompositeNode(NormalizedNode node) throws IOException {
        if (node instanceof ContainerNode) {
            ContainerNode n = (ContainerNode)node;
            this.writer.startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
            return this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
        }
        if (node instanceof MapEntryNode) {
            MapEntryNode n = (MapEntryNode)node;
            return this.writeMapEntryNode(n);
        }
        if (node instanceof UnkeyedListEntryNode) {
            UnkeyedListEntryNode n = (UnkeyedListEntryNode)node;
            this.writer.startUnkeyedListItem(n.name(), n.size());
            return this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
        }
        if (node instanceof ChoiceNode) {
            ChoiceNode n = (ChoiceNode)node;
            this.writer.startChoiceNode((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
            return this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
        }
        if (node instanceof UnkeyedListNode) {
            UnkeyedListNode n = (UnkeyedListNode)node;
            this.writer.startUnkeyedList((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
            return this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
        }
        if (node instanceof UserMapNode) {
            UserMapNode n = (UserMapNode)node;
            this.writer.startOrderedMapNode((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
            return this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
        }
        if (node instanceof SystemMapNode) {
            SystemMapNode n = (SystemMapNode)node;
            this.writer.startMapNode((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
            return this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
        }
        if (node instanceof UserLeafSetNode) {
            UserLeafSetNode n = (UserLeafSetNode)node;
            this.writer.startOrderedLeafSet((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
            return this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
        }
        if (node instanceof SystemLeafSetNode) {
            SystemLeafSetNode n = (SystemLeafSetNode)node;
            this.writer.startLeafSet((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
            return this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
        }
        return false;
    }

    private static final class OrderedNormalizedNodeWriter
    extends NormalizedNodeWriter {
        private static final Logger LOG = LoggerFactory.getLogger(OrderedNormalizedNodeWriter.class);

        OrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer) {
            super(writer);
        }

        @Override
        protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
            NormalizedNodeStreamWriter nnWriter = this.getWriter();
            nnWriter.startMapEntryNode(node.name(), node.size());
            Set<QName> qnames = node.name().keySet();
            for (QName qname : qnames) {
                DataContainerChild child = (DataContainerChild)node.childByArg(new YangInstanceIdentifier.NodeIdentifier(qname));
                if (child != null) {
                    this.write(child);
                    continue;
                }
                LOG.info("No child for key element {} found", (Object)qname);
            }
            return this.writeChildren(Iterables.filter((Iterable)node.body(), input -> {
                if (qnames.contains(input.name().getNodeType())) {
                    LOG.debug("Skipping key child {}", input);
                    return false;
                }
                return true;
            }));
        }
    }
}

