/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;

@Beta
public final class StoreTreeNodes {
    private StoreTreeNodes() {
    }

    public static <T extends StoreTreeNode<T>> Optional<? extends T> findNode(T tree, YangInstanceIdentifier path) {
        T current;
        Iterator<YangInstanceIdentifier.PathArgument> pathIter = path.getPathArguments().iterator();
        for (current = tree; current != null && pathIter.hasNext(); current = current.childByArg(pathIter.next())) {
        }
        return Optional.ofNullable(current);
    }

    public static <T extends StoreTreeNode<T>> T findNodeChecked(T tree, YangInstanceIdentifier path) {
        T current = tree;
        int depth = 1;
        for (YangInstanceIdentifier.PathArgument pathArg : path.getPathArguments()) {
            if ((current = current.childByArg(pathArg)) == null) {
                throw new IllegalArgumentException(String.format("Child %s is not present in tree.", path.getAncestor(depth)));
            }
            ++depth;
        }
        return current;
    }

    public static <T extends StoreTreeNode<T>> Map.Entry<YangInstanceIdentifier, T> findClosest(T tree, YangInstanceIdentifier path) {
        return StoreTreeNodes.findClosestsOrFirstMatch(tree, path, input -> false);
    }

    public static <T extends StoreTreeNode<T>> Map.Entry<YangInstanceIdentifier, T> findClosestsOrFirstMatch(T tree, YangInstanceIdentifier path, Predicate<T> predicate) {
        T parent = tree;
        T current = tree;
        int nesting = 0;
        Iterator<YangInstanceIdentifier.PathArgument> pathIter = path.getPathArguments().iterator();
        while (current != null && pathIter.hasNext() && !predicate.test(current)) {
            parent = current;
            current = current.childByArg(pathIter.next());
            ++nesting;
        }
        if (current != null) {
            YangInstanceIdentifier currentPath = path.getAncestor(nesting);
            return new AbstractMap.SimpleImmutableEntry<YangInstanceIdentifier, T>(currentPath, current);
        }
        Verify.verify((nesting > 0 ? 1 : 0) != 0);
        return new AbstractMap.SimpleImmutableEntry<YangInstanceIdentifier, T>(path.getAncestor(nesting - 1), parent);
    }
}

