/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.FileChannelJournalSegmentReader;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalSerdes;
import io.atomix.storage.journal.MappedJournalSegmentReader;
import io.atomix.storage.journal.StorageException;
import io.atomix.storage.journal.index.JournalIndex;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

class MappableJournalSegmentReader<E>
implements JournalReader<E> {
    private final JournalSegment<E> segment;
    private final FileChannel channel;
    private final int maxEntrySize;
    private final JournalIndex index;
    private final JournalSerdes namespace;
    private JournalReader<E> reader;

    MappableJournalSegmentReader(FileChannel channel, JournalSegment<E> segment, int maxEntrySize, JournalIndex index, JournalSerdes namespace) {
        this.channel = channel;
        this.segment = segment;
        this.maxEntrySize = maxEntrySize;
        this.index = index;
        this.namespace = namespace;
        this.reader = new FileChannelJournalSegmentReader<E>(channel, segment, maxEntrySize, index, namespace);
    }

    void map(ByteBuffer buffer) {
        if (!(this.reader instanceof MappedJournalSegmentReader)) {
            JournalReader<E> reader = this.reader;
            this.reader = new MappedJournalSegmentReader<E>(buffer, this.segment, this.maxEntrySize, this.index, this.namespace);
            this.reader.reset(reader.getNextIndex());
            reader.close();
        }
    }

    void unmap() {
        if (this.reader instanceof MappedJournalSegmentReader) {
            JournalReader<E> reader = this.reader;
            this.reader = new FileChannelJournalSegmentReader<E>(this.channel, this.segment, this.maxEntrySize, this.index, this.namespace);
            this.reader.reset(reader.getNextIndex());
            reader.close();
        }
    }

    @Override
    public long getFirstIndex() {
        return this.reader.getFirstIndex();
    }

    @Override
    public long getCurrentIndex() {
        return this.reader.getCurrentIndex();
    }

    @Override
    public Indexed<E> getCurrentEntry() {
        return this.reader.getCurrentEntry();
    }

    @Override
    public long getNextIndex() {
        return this.reader.getNextIndex();
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public Indexed<E> next() {
        return this.reader.next();
    }

    @Override
    public void reset() {
        this.reader.reset();
    }

    @Override
    public void reset(long index) {
        this.reader.reset(index);
    }

    @Override
    public void close() {
        this.reader.close();
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        finally {
            this.segment.closeReader(this);
        }
    }
}

