/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.spi;

import com.google.common.collect.ForwardingObject;
import java.util.Collection;
import java.util.Objects;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingLazyContainerNode;
import org.opendaylight.yangtools.concepts.PrettyTree;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;

public abstract class AbstractBindingLazyContainerNode<T extends DataObject, C>
extends ForwardingObject
implements BindingLazyContainerNode<T> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier identifier;
    private final @NonNull T bindingData;
    private volatile @Nullable ContainerNode delegate;
    private @GuardedBy(value={"this"}) @Nullable C context;

    protected AbstractBindingLazyContainerNode(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier identifier, @NonNull T bindingData, C context) {
        this.identifier = Objects.requireNonNull(identifier);
        this.bindingData = (DataObject)Objects.requireNonNull(bindingData);
        this.context = context;
    }

    public final T getDataObject() {
        return this.bindingData;
    }

    public final YangInstanceIdentifier.NodeIdentifier name() {
        return this.identifier;
    }

    @Deprecated(since="12.0.0", forRemoval=true)
    public final YangInstanceIdentifier.NodeIdentifier getIdentifier() {
        return this.identifier;
    }

    public final ContainerNode getDelegate() {
        return this.delegate();
    }

    public Collection<@NonNull DataContainerChild> body() {
        return this.delegate().body();
    }

    public DataContainerChild childByArg(YangInstanceIdentifier.NodeIdentifier child) {
        return (DataContainerChild)this.delegate().childByArg((YangInstanceIdentifier.PathArgument)child);
    }

    public PrettyTree prettyTree() {
        return new PrettyTree(){

            public void appendTo(StringBuilder sb, int depth) {
                AbstractBindingLazyContainerNode.this.delegate().prettyTree().appendTo(sb, depth);
            }
        };
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ContainerNode)) return false;
        ContainerNode other = (ContainerNode)obj;
        if (!this.delegate().equals(other)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final @NonNull ContainerNode delegate() {
        ContainerNode local = this.delegate;
        if (local == null) {
            AbstractBindingLazyContainerNode abstractBindingLazyContainerNode = this;
            synchronized (abstractBindingLazyContainerNode) {
                local = this.delegate;
                if (local == null) {
                    this.delegate = local = Objects.requireNonNull(this.computeContainerNode(this.context));
                    this.context = null;
                }
            }
        }
        return local;
    }

    protected abstract @GuardedBy(value={"this"}) @NonNull ContainerNode computeContainerNode(C var1);
}

